/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;

import java.io.Serializable;

/**
 * 导出-瓜子offer信息接收表
 *
 * @author hgw
 * @date 2025-6-17 09:38:47
 */
@Data
@ColumnWidth(25)
public class TGzOfferInfoExportMainVo implements Serializable {

	@ExcelProperty("流程ID")
	private String bizId;

	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("证件号码")
	private String nationalId;
	@ExcelProperty("个人手机号")
	private String phone;
	@ExcelProperty("职务描述")
	private String jobcodeDescr;
	@ExcelProperty("预计入职日期")
	private String expEntryDate;

	@ExcelProperty("接收瓜子Offer时间")
	private String createTime;

	@ExcelAttribute(name = "Offer短信通知状态", isDataId = true, readConverterExp = "0=已发送,1=未发送")
	@ExcelProperty("Offer短信通知状态")
	private String offerSendStatus;

	@ExcelAttribute(name = "Offer短信通知状态", isDataId = true, readConverterExp = "3=待发送Offer,4=待接受Offer,5=拒绝Offer,7=接受offer,9=候选人填写信息,10=取消offer,12=候选人信息审核,13=待签署,8=合同审核通过,99=已归档,98=信息待收集,97=候选人审核通过")
	@ExcelProperty("Offer状态")
	private String offerStatus;

}
