/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpSkill;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpSkillService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpSkillSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 瓜子技能证书
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzempskill")
@Tag(name = "瓜子技能证书管理")
public class TGzEmpSkillController {

	private final TGzEmpSkillService tGzEmpSkillService;


	/**
	 * 简单分页查询
	 *
	 * @param page        分页对象
	 * @param tGzEmpSkill 瓜子技能证书
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TGzEmpSkill>> getTGzEmpSkillPage(Page<TGzEmpSkill> page, TGzEmpSkillSearchVo tGzEmpSkill) {
		return new R<>(tGzEmpSkillService.getTGzEmpSkillPage(page, tGzEmpSkill));
	}

	/**
	 * 不分页查询
	 *
	 * @param tGzEmpSkill 瓜子技能证书
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TGzEmpSkill>> getTGzEmpSkillNoPage(@RequestBody TGzEmpSkillSearchVo tGzEmpSkill) {
		return R.ok(tGzEmpSkillService.noPageDiy(tGzEmpSkill));
	}

	/**
	 * 通过id查询瓜子技能证书
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzempskill_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempskill_get')")
	public R<TGzEmpSkill> getById(@PathVariable("id") String id) {
		return R.ok(tGzEmpSkillService.getById(id));
	}

}
