/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author fxj
 * @date 2024-06-17 14:29:11
 */
@Mapper
public interface TEmpContactInfoMapper extends BaseMapper<TEmpContactInfo> {
	/**
	 * 简单分页查询
	 *
	 * @param tEmpContactInfo
	 * @return
	 */
	IPage<TEmpContactInfo> getTEmpContactInfoPage(Page<TEmpContactInfo> page, @Param("tEmpContactInfo") TEmpContactInfo tEmpContactInfo);

	/**
	 * @param deptId
	 * @Description: 获取紧急联系人信息
	 * @Author: hgw
	 * @Date: 2024/10/17 19:42
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo>
	 **/
	List<TEmpContactInfo> getContactByDeptId(@Param("deptId") String deptId);

	List<TEmpContactInfo> getContactByIdCardList(@Param("idCardList") List<String> idCardList);
}
