/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 自动化日志
 *
 * @author hgw
 * @date 2024-08-30 10:27:16
 */
@Data
@TableName("t_social_soldier_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "自动化日志")
public class TSocialSoldierLog extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 社保ID
	 */
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Length(max = 32, message = "社保ID不能超过32个字符")
	@ExcelProperty("社保ID")
	@Schema(description = "社保ID")
	private String socialId;
	/**
	 * 推送的任务ID
	 */
	@ExcelAttribute(name = "推送的任务ID", maxLength = 32)
	@Length(max = 32, message = "推送的任务ID不能超过32个字符")
	@ExcelProperty("推送的任务ID")
	@Schema(description = "推送的任务ID")
	private String addId;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 20)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 派单项：社保;医保
	 */
	@ExcelAttribute(name = "派单项：社保;医保", maxLength = 2)
	@Length(max = 2, message = "派单项：社保;医保不能超过2个字符")
	@ExcelProperty("派单项：社保;医保")
	@Schema(description = "派单项：社保;医保")
	private String dispatchItem;

	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Length(max = 2, message = "社保户不能超过50个字符")
	@ExcelProperty("社保户")
	@Schema(description = "社保户")
	private String socialHuName;
	/**
	 * 类型：提交；审核
	 */
	@ExcelAttribute(name = "类型：提交；审核", maxLength = 2)
	@Length(max = 2, message = "类型：提交；审核不能超过2个字符")
	@ExcelProperty("类型：提交；审核")
	@Schema(description = "类型：提交；审核")
	private String type;
	/**
	 * 结果
	 */
	@ExcelAttribute(name = "结果", maxLength = 50)
	@Length(max = 50, message = "结果不能超过50个字符")
	@ExcelProperty("结果")
	@Schema(description = "结果")
	private String remark;

}
