package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialWarnService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Author hgw
 * @Date2025-8-1 11:19:32
 * @Description 派单提醒相关
 * @Version 1.0
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/socialWarn")
@Tag(name = "派单提醒相关")
public class TSocialWarnController {

	@Resource
	private TSocialWarnService socialWarnService;

	@Operation(description = "每天10：00推送派单办理失败的消息")
	@Inner
	@PostMapping("/inner/pushSocialAlertToWx")
	public void pushSocialAlertToWx() {
		socialWarnService.pushSocialAlertToWx();
	}
}
