/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.equator.HrEquator;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialLog;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSocialLogMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialLogService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

import static com.alibaba.fastjson.serializer.SerializerFeature.*;

/**
 * 社保变更记录表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
@Service
public class TSocialLogServiceImpl extends ServiceImpl<TSocialLogMapper, TSocialLog> implements TSocialLogService {
	/**
	 * 社保变更记录表简单分页查询
	 *
	 * @param tSocialLog 社保变更记录表
	 * @return
	 */
	@Override
	public IPage<TSocialLog> getTSocialLogPage(Page<TSocialLog> page, TSocialLog tSocialLog) {
		return baseMapper.getTSocialLogPage(page, tSocialLog);
	}

	/**
	 * @param type   类型：1社保基数配置；2公积金基数配置
	 * @param mainId
	 * @Description:
	 * @Author: hgw
	 * @Date: 2022/7/12 9:52
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeLog
	 **/
	@Override
	public <T> TSocialLog saveModificationRecord(Integer type, String mainId, T oldInfo, T newInfo) {
		try {
			//比较记录不影响业务逻辑，用try套住
			//比较差异
			String differenceKey = HrEquator.comparisonValue(oldInfo, newInfo);
			//如果有差异保存差异
			if (!Common.isEmpty(differenceKey)) {
				TSocialLog socialLog = new TSocialLog();
				socialLog.setType(type);
				socialLog.setMainId(mainId);
				socialLog.setCreateTime(LocalDateTime.now());
				socialLog.setOldInfo(JSON.toJSONString(oldInfo, features));
				socialLog.setNewInfo(JSON.toJSONString(newInfo, features));
				socialLog.setDifferenceInfo(differenceKey);
				baseMapper.insert(socialLog);
				return socialLog;
			}
		} catch (Exception e) {
			log.error(JSON.toJSON(oldInfo) + "【新增社保变更记录】报错>>>", e);
		}
		return null;
	}

	private SerializerFeature[] features = new SerializerFeature[]{
			WriteMapNullValue, WriteNullNumberAsZero, WriteNullListAsEmpty,
			WriteNullStringAsEmpty, WriteDateUseDateFormat
	};

}
