package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @description: 更新人员信息拓展表dto
 * @author: wangweiguo
 * @date: 2021/8/10
 */
@Getter
@Setter
@ToString
public class UpdateBusinessEmployeeExtendDTO implements Serializable {

    /**
     * 拓展表id
     */
	@Schema(description = "拓展表id")
    private String extendId;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号码")
	@NotBlank(message = "身份证号码不能为空")
    private String empIdcard;

    /**
     * 姓名
     */
	@Schema(description = "姓名")
	private String empName;

    /**
     * 部门名称
     */
	@Schema(description = "部门名称")
	@NotBlank(message = "部门名称不能为空")
    @Length(max = 50, message = "部门名称长度不超过50字符")
    private String departName;

    /**
     * 部门id
     */
	@Schema(description = "部门id")
	private Integer departId;

    /**
     * 部门编码
     */
	@Schema(description = "部门编码")
	private String departCode;

    /**
     * b端岗位
     */
	@Schema(description = "b端岗位")
	@Length(max = 50, message = "岗位长度不超过50字符")
    private String businessPost;

    /**
     * b端员工工号
     */
	@Schema(description = "电信工号")
    @Length(max = 20, message = "电信工号长度不超过20字符")
    @NotBlank(message = "电信工号不能为空")
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
	@Schema(description = "标签，字典值（英文逗号分割）")
	private String employeeTags;

    /**
     * 第一学历和专业
     */
	@Schema(description = "第一学历和专业")
	@Length(max = 20, message = "第一学历和专业长度不超过20字符")
    private String firstDegreeAndMajor;

    /**
     * 第一学历院校
     */
	@Schema(description = "第一学历院校")
	@Length(max = 20, message = "第一学历院校长度不超过20字符")
    private String firstDegreeGraduateSchool;

    /**
     * 最高学历和专业
     */
	@Schema(description = "最高学历和专业")
	@Length(max = 20, message = "最高学历和专业长度不超过20字符")
    private String highestDegreeAndMajor;

    /**
     * 最高学历院校
     */
	@Schema(description = "最高学历院校")
	@Length(max = 20, message = "最高学历院校长度不超过20字符")
    private String highestDegreeGraduateSchool;

    /**
     * 联系方式
     */
	@Schema(description = "联系方式")
	@Length(max = 11, message = "联系方式长度不超过11字符")
    @Pattern(regexp = "(?:(?:\\+|00)86)?1\\d{10}", message = "联系方式格式错误")
    @NotBlank(message = "联系方式不能为空")
    private String contactInfo;

    /**
     * 档案托管地
     */
	@Schema(description = "档案托管地")
	@Length(max = 20, message = "档案托管地长度不超过20字符")
    private String archivesAddr;

    /**
     * B端维护的离职时间
     */
	@Schema(description = "B端维护的离职时间")
	private LocalDate businessLeaveDate;

    /**
     * B端维护的入职时间
     */
	@Schema(description = "B端维护的入职时间")
	@NotNull(message = "入职时间不能为空")
    private LocalDate businessEnjoinDate;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
