/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoRuleLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoRuleLogService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoRuleLogSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 规则变更日志表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautorulelog" )
@Tag(name = "规则变更日志表管理")
public class TAutoRuleLogController {

    private final  TAutoRuleLogService tAutoRuleLogService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAutoRuleLog 规则变更日志表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAutoRuleLog>> getTAutoRuleLogPage(Page<TAutoRuleLog> page, TAutoRuleLogSearchVo tAutoRuleLog) {
        return  new R<>(tAutoRuleLogService.getTAutoRuleLogPage(page,tAutoRuleLog));
    }

}
