package com.yifu.cloud.plus.v1.business.vo.vacation;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @description: 假期监控表 分页查询展示 vo
 * @author: wangweiguo
 * @date: 2021-08-13
*/
@Setter
@Getter
@ToString
public class TVacationMonitorVO implements Serializable  {

    /**
     * 主键
     */
	@Schema(description = "主键")
    private String id;

    /**
     * 年份
     */
	@Schema(description = "年份")
	private String vacationYear;

    /**
     * 电信工号
     */
	@Schema(description = "电信工号")
	private String businessTelecomNumber;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号")
	private String empIdcard;

    /**
     * 姓名
     */
	@Schema(description = "姓名")
	private String empName;

    /**
     * 部门编码
     */
	@Schema(description = "所属部门编码")
	private String departCode;

    /**
     * 部门名称
     */
	@Schema(description = "所属部门名称")
	private String departName;

    /**
     * 部门id
     */
	@Schema(description = "部门id")
	private Integer departId;

    /**
     * b端岗位
     */
	@Schema(description = "岗位")
	private String businessPost;

    /**
     * 假期时长
     */
	@Schema(description = "年假时长")
	private BigDecimal vacationDuration;

    /**
     * 未使用假期时长
     */
	@Schema(description = "未休时长")
	private BigDecimal notUsedVacationDuration;

    /**
     * 入职时间
     */
	@Schema(description = "入职时间")
	private LocalDateTime businessEnjoinDate;

    /**
     * 在岗工龄
     */
	@Schema(description = "在岗工龄")
	private BigDecimal workingAge;

    /**
     * 休假状态 0未休完 1已休完
     */
	@Schema(description = "休假状态 0未休完 1已休完")

	private String vacationStatus;

    private static final long serialVersionUID = 1L;

}

