/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.time.LocalDateTime;

/**
 * 工行返回的数据记录表
 *
 * @author hgw
 * @date 2024-11-27 16:50:15
 */
@Data
@TableName("ekp_bank_icbc_log")
@Schema(description = "工行返回的数据记录表")
public class EkpBankIcbcLog {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 批次号
	 */
	@ExcelAttribute(name = "批次号", maxLength = 50)
	@Length(max = 50, message = "批次号不能超过50个字符")
	@ExcelProperty("批次号")
	@Schema(description = "批次号")
	private String fdWxNo;

	/**
	 * 关联ID
	 */
	@ExcelAttribute(name = "关联ID", maxLength = 36)
	@Length(max = 36, message = "关联ID不能超过36个字符")
	@ExcelProperty("关联ID")
	@Schema(description = "关联ID")
	private String fdParentId;
	/**
	 * 类型
	 */
	@ExcelAttribute(name = "类型", maxLength = 1)
	@Length(max = 36, message = "类型不能超过1个字符")
	@ExcelProperty("类型")
	@Schema(description = "类型：1：提交；2：获取结果")
	private Integer fdType;
	/**
	 * 日志
	 */
	@ExcelAttribute(name = "日志")
	@ExcelProperty("日志")
	@Schema(description = "日志")
	private String fdLog;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime fdCreateTime;

}
