package com.yifu.cloud.plus.v1.permission.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserPermission;
import com.yifu.cloud.plus.v1.yifu.permission.vo.IdTypeEkpVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysDictVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserDeptVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserPermissionSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 新权限-用户权限表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
public interface SysUserPermissionService extends IService<SysUserPermission> {
    /**
     * 新权限-用户权限表简单分页查询
     * @param sysUserPermission 新权限-用户权限表
     * @return
     */
    IPage<SysUserPermission> getSysUserPermissionPage(Page<SysUserPermission> page, SysUserPermissionSearchVo sysUserPermission);

	/**
	 * 新增权限
	 * @param sysUserPermission 新权限-用户权限表
	 */
	R savePermission(SysUserPermission sysUserPermission);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, SysUserPermissionSearchVo searchVo);

	/**
	 * 新权限-用户权限表简单分页查询
	 * @param searchVo
	 * @return
	 */
	IPage<SysUserDeptVo> getNameCodePage(Page<SysUserDeptVo> page, SysUserDeptVo searchVo);

	List<SysDictVo> selectDictByType(String type);

	R<String> autoCreateAuth(IdTypeEkpVo vo);
}
