/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 薪资原表识别配置导出vo
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
@Data
@Schema(description = "薪资代发户配置导出Vo")
public class TSalaryOriginalExportVo {

	@ExcelAttribute(name = "项目编码", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "原表类型", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表类型")
	private String setName;

	@ExcelAttribute(name = "申请人", maxLength = 50)
	@Schema(description = "申请人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请人")
	private String createName;

	@ExcelAttribute(name = "申请时间", maxLength = 50)
	@Schema(description = "申请时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请时间")
	private String createTime;

}
