/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardOriginal;
import com.yifu.cloud.plus.v1.yifu.salary.vo.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 薪资原表识别
 *
 * @author hgw
 * @date 2024-4-2 17:20:36
 */
public interface TSalaryStandardOriginalService extends IService<TSalaryStandardOriginal> {
	/**
	 * @Description: 分页查询
	 * @Author: hgw
	 * @Date: 2024/4/2 17:20
	 * @return:
	 **/
	IPage<TSalaryStandardOriginal> getTSalaryStandardOriginalPage(Page<TSalaryStandardOriginal> page, TSalaryStandardOriginal tSalaryStandardOriginal);

	List<TSalaryStandardOriginal> getTSalaryStandardOriginalList(TSalaryStandardOriginal tSalaryStandardOriginal);

	List<String> getSpecialIdCardList();

	/**
	 * @param file
	 * @Description: 识别表头主类
	 * @Author: hgw
	 * @Date: 2024/4/3 17:40
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.salary.vo.ExcelVo>
	 **/
	R<ExcelSheetVo> getExcelHeader(MultipartFile file, String sheetName);

	/**
	 * @param excelVo
	 * @Description: 新版原表识别导入
	 * @Author: hgw
	 * @Date: 2024/4/8 18:05
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<SalaryUploadParamVo> salaryUploadByOriginal(MultipartFile file, SalaryUploadOriginalParamVo excelVo);

	/**
	 * @Description: 薪资原表配置导出
	 * @Author: hgw
	 * @Date: 2024/5/13 17:47
	 * @return: void
	 **/
	void exportOriginal(HttpServletResponse response, TSalaryOriginalSearchVo searchVo);

}
