/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDiySqlMenuRel;

import java.util.List;

/**
 * @Description: 自定义sql与菜单的关联表接口
 * @Author: hgw
 * @Date: 2022/6/8 17:15
 **/
public interface SysDiySqlMenuRelService extends IService<SysDiySqlMenuRel> {
	/**
	 * @param mainId 权限主表id
	 * @Description: 删除
	 * @Author: hgw
	 * @Date: 2022/6/9 14:28
	 * @return: int
	 **/
	int deleteSqlMenuRelByAuthId(String mainId);

	/**
	 * @param mainId 权限主表id
	 * @Description: 根据权限主表id查询
	 * @Author: hgw
	 * @Date: 2022/6/9 14:28
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDiySqlMenuRel>
	 **/
	List<SysDiySqlMenuRel> getByMainId(String mainId);
}
