package com.yifu.cloud.plus.v1.business.vo.salary;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 部门合计VO
 *
 * @author: wangweiguo
 * @date: 2021/9/7
 */

@Setter
@Getter
@ToString
public class TSalaryTotalVO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 应发合计 9位整数 2位小数
     */
    @Schema(description ="合计：应发合计")
    private BigDecimal payableTotal;
    /**
     * 应发合计差额 9位整数 2位小数
     */
    @Schema(description ="合计：应发合计差额")
    private BigDecimal payableTotalOffset;
    /**
     * 应发合计差额标识 0减少 1不变 2增加
     */
    @Schema(description ="应发合计差额标识 0减少 1不变 2增加")
    private String payableTotalFlag;
    /**
     * 实发工资 8位整数 2位小数
     */
    @Schema(description ="合计：实发工资")
    private BigDecimal actualSalary;
    /**
     * 实发工资差额 8位整数 2位小数
     */
    @Schema(description ="合计：实发工资差额")
    private BigDecimal actualSalaryOffset;
    /**
     * 实发工资差额标识 0减少 1不变 2增加
     */
    @Schema(description ="实发工资差额标识 0减少 1不变 2增加")
    private String actualSalaryFlag;
    /**
     * 人均成本 8位整数 2位小数
     */
    @Schema(description ="合计：人均成本")
    private BigDecimal perCapita;
    /**
     * 人均成本差额 8位整数 2位小数
     */
    @Schema(description ="合计：人均成本差额")
    private BigDecimal perCapitaOffset;
    /**
     * 人均成本差额标识 0减少 1不变 2增加
     */
    @Schema(description ="人均成本差额标识 0减少 1不变 2增加")
    private String perCapitaFlag;
}
