package com.yifu.cloud.plus.v1.yifu.permission.entity;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
@TableName("sys_user_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "新权限-账号管理表")
public class SysUserInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * ele表-员工姓名
	 */
	@ExcelAttribute(name = "ele表-员工姓名", maxLength = 200)
	@Length(max = 200, message = "ele表-员工姓名不能超过200个字符")
	@ExcelProperty("ele表-员工姓名")
	@Schema(description = "ele表-员工姓名")
	private String fdName;
	/**
	 * per表-登录账号
	 */
	@ExcelAttribute(name = "per表-登录账号", maxLength = 200)
	@Length(max = 200, message = "per表-登录账号不能超过200个字符")
	@ExcelProperty("per表-登录账号")
	@Schema(description = "per表-登录账号")
	private String fdLoginName;
	/**
	 * ele表-所在部门
	 */
	@ExcelAttribute(name = "ele表-所在部门", maxLength = 450)
	@Length(max = 450, message = "ele表-所在部门不能超过450个字符")
	@ExcelProperty("ele表-所在部门")
	@Schema(description = "ele表-所在部门")
	private String fdLdapDn;
	/**
	 * 所在部门
	 */
	@ExcelAttribute(name = "所在部门", maxLength = 100)
	@Length(max = 100, message = "所在部门不能超过100个字符")
	@ExcelProperty("所在部门")
	@Schema(description = "所在部门")
	private String fdDeptName;
	/**
	 * per表-手机号
	 */
	@ExcelAttribute(name = "per表-手机号", maxLength = 150)
	@Length(max = 150, message = "per表-手机号不能超过150个字符")
	@ExcelProperty("per表-手机号")
	@Schema(description = "per表-手机号")
	private String fdMobileNo;
	/**
	 * per表-邮箱
	 */
	@ExcelAttribute(name = "per表-邮箱", maxLength = 200)
	@Length(max = 200, message = "per表-邮箱不能超过200个字符")
	@ExcelProperty("per表-邮箱")
	@Schema(description = "per表-邮箱")
	private String fdEmail;
	/**
	 * 状态：0正常；1冻结
	 */
	@ExcelAttribute(name = "状态：0正常；1冻结", isNotEmpty = true, errorInfo = "状态：0正常；1冻结不能为空")
	@NotBlank(message = "状态：0正常；1冻结不能为空")
	@ExcelProperty("状态：0正常；1冻结")
	@Schema(description = "状态：0正常；1冻结")
	private Integer status;
	/**
	 * 角色名称合集
	 */
	@TableField(exist = false)
	private String roleNames;

}
