/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.SysAutoDict;
import com.yifu.cloud.plus.v1.yifu.archives.service.SysAutoDictService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SysAutoDictSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 字典表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysautodict" )
@Tag(name = "字典表管理")
public class SysAutoDictController {

    private final  SysAutoDictService sysAutoDictService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param sysAutoDict 字典表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysAutoDict>> getSysAutoDictPage(Page<SysAutoDict> page, SysAutoDictSearchVo sysAutoDict) {
        return  new R<>(sysAutoDictService.getSysAutoDictPage(page,sysAutoDict));
    }
    /**
     * 不分页查询
     * @param sysAutoDict 字典表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_sysautodict_get')" )
    public R<List<SysAutoDict>> getSysAutoDictNoPage(@RequestBody SysAutoDictSearchVo sysAutoDict) {
        return R.ok(sysAutoDictService.noPageDiy(sysAutoDict));
    }

    /**
     * 通过id查询字典表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_sysautodict_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_sysautodict_get')" )
    public R<SysAutoDict> getById(@PathVariable("id" ) Long id) {
        return R.ok(sysAutoDictService.getById(id));
    }

    /**
     * 新增字典表
     * @param sysAutoDict 字典表
     * @return R
     */
    @Operation(summary = "新增字典表", description = "新增字典表：hasPermission('demo_sysautodict_add')")
    @SysLog("新增字典表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_sysautodict_add')" )
    public R<Boolean> save(@RequestBody SysAutoDict sysAutoDict) {
        return R.ok(sysAutoDictService.save(sysAutoDict));
    }

    /**
     * 修改字典表
     * @param sysAutoDict 字典表
     * @return R
     */
    @Operation(summary = "修改字典表", description = "修改字典表：hasPermission('demo_sysautodict_edit')")
    @SysLog("修改字典表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_sysautodict_edit')" )
    public R<Boolean> updateById(@RequestBody SysAutoDict sysAutoDict) {
        return R.ok(sysAutoDictService.updateById(sysAutoDict));
    }

    /**
     * 通过id删除字典表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除字典表", description = "通过id删除字典表：hasPermission('demo_sysautodict_del')")
    @SysLog("通过id删除字典表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_sysautodict_del')" )
    public R<Boolean> removeById(@PathVariable Long id) {
        return R.ok(sysAutoDictService.removeById(id));
    }

    /**
	 * 字典表 批量导入
	 *
     * @author fxj
     * @date 2025-03-13 15:15:26
	 **/
    @SneakyThrows
    @Operation(description = "批量新增字典表 hasPermission('demo_sysautodict-batch-import')")
    @SysLog("批量新增字典表")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_sysautodict-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return sysAutoDictService.importDiy(file.getInputStream());
    }

    /**
     * 字典表 批量导出
     * @author fxj
     * @date 2025-03-13 15:15:26
     **/
    @Operation(description = "导出字典表 hasPermission('demo_sysautodict-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_sysautodict-export')")
    public void export(HttpServletResponse response, @RequestBody SysAutoDictSearchVo searchVo) {
            sysAutoDictService.listExport(response,searchVo);
    }
}
