package com.yifu.cloud.plus.v1.csp.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.entity.EmployeeRegistration;
import com.yifu.cloud.plus.v1.csp.service.EmployeeRegistrationService;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationReceiveVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationSearchVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProjectBelongDept;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeProjectBelongDeptSearchCspVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/employeeregistration")
@Tag(name = "入离职登记表管理")
public class EmployeeRegistrationController {

	private final EmployeeRegistrationService employeeRegistrationService;

	private final MenuUtil menuUtil;

	/**
	 * 简单分页查询
	 *
	 * @param page                 分页对象
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<EmployeeRegistration>> getEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration) {
		// 1.9.8：客户服务平台仅展示来源是“客户端”的数据
		employeeRegistration.setDataSource(CommonConstants.ONE_STRING);
		return new R<>(employeeRegistrationService.getEmployeeRegistrationPage(page, employeeRegistration));
	}

	/**
	 * 入离职登记表代办列表简单分页查询
	 *
	 * @param page                 分页对象
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	@Operation(description = "入离职登记表代办列表简单分页查询")
	@GetMapping("/hrPage")
	public R<IPage<EmployeeRegistration>> getHrEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, employeeRegistration);
		return new R<>(employeeRegistrationService.getHrEmployeeRegistrationPage(page, employeeRegistration));
	}

	/**
	 * 作业自动化-入离职登记列表简单分页查询
	 *
	 * @param page                 分页对象
	 * @param employeeRegistration 入离职登记表
	 * @return R<IPage<EmployeeRegistration>>
	 * @author chenyuxi
	 * @date 2025-03-21
	 * @since 1.9.8
	 */
	@Operation(description = "作业自动化-入离职登记列表简单分页查询")
	@GetMapping("/hrRegistrationPage")
	public R<IPage<EmployeeRegistration>> getHrAutoEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, employeeRegistration);
		return new R<>(employeeRegistrationService.getHrAutoEmployeeRegistrationPage(page, employeeRegistration));
	}

	/**
	 * 通过id查询入离职登记表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission(' ')")
	@GetMapping("/{id}")
	public R<EmployeeRegistration> getById(@PathVariable("id") String id) {
		return R.ok(employeeRegistrationService.getById(id));
	}

	/**
	 * 新增入离职登记表
	 *
	 * @param employeeRegistration 入离职登记表
	 * @return R
	 */
	@Operation(summary = "新增入离职登记表")
	@SysLog("新增入离职登记表")
	@PostMapping("/registAdd")
	public R registAdd(@RequestBody EmployeeRegistration employeeRegistration) {
		return employeeRegistrationService.registAdd(employeeRegistration);
	}

	/**
	 * 修改入离职登记表
	 *
	 * @param employeeRegistration 入离职登记表
	 * @return R
	 */
	@Operation(summary = "修改入离职登记表")
	@SysLog("修改入离职登记表")
	@PostMapping("/updateById")
	public R updateById(@RequestBody EmployeeRegistration employeeRegistration) {
		return employeeRegistrationService.updateRegist(employeeRegistration);
	}

	/**
	 * 入离职登记表确认接收
	 *
	 * @param employeeRegistration 入离职登记表
	 * @return R
	 */
	@Operation(summary = "确认接收")
	@SysLog("确认接收")
	@PostMapping("/confirmSubmit")
	public R confirmSubmit(@RequestBody EmployeeRegistration employeeRegistration) {
		return employeeRegistrationService.confirmSubmit(employeeRegistration);
	}

	/**
	 * 通过id删除入离职登记表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除入离职登记表", description = "通过id删除入离职登记表：hasPermission('csp_employeeregistration_del')")
	@SysLog("通过id删除入离职登记表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('csp_employeeregistration_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(employeeRegistrationService.removeById(id));
	}

	/**
	 * 入离职登记表 批量导入
	 *
	 * @author huych
	 * @date 2025-02-25 14:48:11
	 **/
	@SneakyThrows
	@Operation(description = "批量新增入离职登记表")
	@SysLog("批量新增入离职登记表")
	@PostMapping("/importListAdd")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file,String deptId,String dataSource) {
		return employeeRegistrationService.importDiy(file.getInputStream(),deptId, dataSource);
	}

	/**
	 * 入离职登记表 批量导出
	 *
	 * @author huych
	 * @date 2025-02-25 14:48:11
	 **/
	@Operation(description = "导出入离职登记表")
	@PostMapping("/export")
	public void export(HttpServletResponse response, @RequestBody EmployeeRegistrationSearchVo searchVo) {
		// 1.9.8：客户服务平台仅展示来源是“客户端”的数据
		searchVo.setDataSource(CommonConstants.ONE_STRING);
		employeeRegistrationService.listExport(response, searchVo);
	}

	/**
	 * 入离职登记表 批量导出
	 *
	 * @author huych
	 * @date 2025-02-25 14:48:11
	 **/
	@Operation(description = "导出入离职待办任务")
	@PostMapping("/hrExport")
	public void hrExport(HttpServletResponse response, @RequestBody EmployeeRegistrationSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		employeeRegistrationService.listHrExport(response, searchVo);
	}

	/**
	 * 作业自动化-入离职登记导出
	 *
	 * @author chenyuxi
	 * @date 2025-03-21
	 * @since 1.9.8
	 **/
	@Operation(description = "作业自动化-入离职登记导出")
	@PostMapping("/hrRegistrationExport")
	public void hrRegistrationExport(HttpServletResponse response, @RequestBody EmployeeRegistrationSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		employeeRegistrationService.hrRegistrationExport(response, searchVo);
	}

	/**
	 * @Description: 获取已接收的入离职申请，同时更新为已处理
	 * @Author: hgw
	 * @Date: 2025-3-4 09:17:39
	 **/
	@Operation(description = "获取已接收的入离职申请，同时更新为已处理")
	@SysLog("获取已接收的入离职申请，同时更新为已处理" )
	@Inner
	@PostMapping("/inner/getZeroRegistrationAndUpdateTwo" )
	public TEmployeeProjectBelongDept getZeroRegistrationAndUpdateTwo(@RequestBody TEmployeeProjectBelongDeptSearchCspVo searchCspVo) {
		if (searchCspVo != null && Common.isNotNull(searchCspVo.getEmpIdCard())) {
			return employeeRegistrationService.getZeroRegistrationAndUpdateTwo(searchCspVo);
		}
		return null;
	}

	/**
	 * 入职待确认列表简单分页查询
	 *
	 * @param page                 分页对象
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	@Operation(description = "入职待确认列表简单分页查询")
	@GetMapping("/hrConfirmPage")
	public R<IPage<EmployeeRegistration>> getHrConfirmEmployeeRegistrationPage(Page<EmployeeRegistration> page, EmployeeRegistrationSearchVo employeeRegistration) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, employeeRegistration);
		return new R<>(employeeRegistrationService.getHrConfirmEmployeeRegistrationPage(page, employeeRegistration));
	}

	/**
	 * 入职待确认列表查询身份证
	 *
	 * @param employeeRegistration 入离职登记表
	 * @return
	 */
	@Operation(description = "入职待确认列表简单分页查询")
	@GetMapping("/hrConfirmIdcardList")
	public R<List<String>> getHrConfirmIdcardList(EmployeeRegistrationSearchVo employeeRegistration) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, employeeRegistration);
		return R.ok(employeeRegistrationService.getHrConfirmIdcardList(employeeRegistration));
	}

	/**
	 * 入职待确认表 批量导出
	 *
	 * @author huych
	 * @date 2025-03-13 16:55:32
	 **/
	@Operation(description = "导出入职待确认表")
	@PostMapping("/hrConfirmExport")
	public void hrConfirmExport(HttpServletResponse response, @RequestBody EmployeeRegistrationSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		employeeRegistrationService.hrConfirmExport(response, searchVo);
	}

	/**
	 * 入职待确认表 确认接收
	 *
	 * @author huych
	 * @date 2025-03-13 16:55:32
	 **/
	@Operation(description = "入职待确认表确认接收")
	@PostMapping("/confirmReceive")
	public R confirmReceive(@RequestBody EmployeeRegistrationPreVo preVo) {
		return employeeRegistrationService.confirmReceive(preVo);
	}

	/**
	 * 入职待确认表 批量确认接收
	 *
	 * @author huych
	 * @date 2025-03-13 16:55:32
	 **/
	@Operation(description = "入职待确认表批量接收")
	@PostMapping("/batchConfirmReceive")
	public R batchConfirmReceive(@RequestBody EmployeeRegistrationPreVo preVo) {
		return employeeRegistrationService.batchConfirmReceive(preVo);
	}

	/**
	 * 批量修改入离职登记表
	 *
	 * @param employeeRegistList 入离职登记表
	 * @return R
	 */
	@Operation(summary = "批量修改入离职登记表")
	@SysLog("批量入离职登记表")
	@PostMapping("/batchUpdatePreById")
	public R batchUpdatePreById(@RequestBody List<EmployeeRegistrationReceiveVo> employeeRegistList) {
		return employeeRegistrationService.batchUpdatePreById(employeeRegistList);
	}

	/**
	 * 更新入离职登记表
	 *
	 * @param updateVo 状态和日志新增vo
	 * @return R
	 */
	@Operation(summary = "更新入离职登记表")
	@SysLog("更新入离职登记表")
	@Inner
	@PostMapping("/inner/updateRegistByPreInfo")
	public Boolean updateRegistByPreInfo(@RequestBody EmployeeRegistrationUpdateVo updateVo) {
		return employeeRegistrationService.updateRegistByPreInfo(updateVo);
	}

	/**
	 * 更新入离职登记表前端客服信息
	 *
	 * @param updateVo
	 * @return R
	 */
	@Operation(summary = "更新入离职登记表前端客服信息")
	@SysLog("更新入离职登记表前端客服信息")
	@Inner
	@PostMapping("/inner/updateRegistCustomerUserInfo")
	public Boolean updateRegistCustomerUserInfo(@RequestBody EmployeeRegistrationCustomerUserUpdateVo updateVo) {
		return employeeRegistrationService.updateRegistCustomerUserInfo(updateVo);
	}

	/**
	 * 查询入职待确认数量
	 *
	 * @author huych
	 * @date 2025-03-13 16:55:32
	 **/
	@Operation(summary = "查询入职待确认数量")
	@SysLog("查询入职待确认数量")
	@PostMapping("/getRegisterPreCount")
	public R getRegisterPreCount(@RequestBody EmployeeRegistrationSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		return R.ok(employeeRegistrationService.getRegisterPreCount(searchVo));
	}
}
