package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeStandard;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeStandardService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhaji
 * @description 购买标准相关
 * @date 2022-07-18 17:41:36
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceTypeStandard")
@Tag(name = "购买标准相关")
//@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceTypeStandardController {

	@Resource
	private TInsuranceTypeStandardService insuranceTypeStandardService;

	/**
	 * 查询购买标准列表（不分页）
	 * @return
	 */
	@Operation(summary = "购买标准列表", description = "购买标准列表")
	@GetMapping("/list" )
	public R getInsuranceTypeRateList(String id) {
		return insuranceTypeStandardService.getInsuranceTypeStandard(id);
	}

	/**
	 * 根据险种ID查询购买标准列表(未删除，未禁用)
	 * @return
	 */
	@Operation(summary = "根据险种ID查询购买标准列表(未删除，未禁用)", description = "购买标准列表2 传参险种ID riskId")
	@GetMapping("/listEnable" )
	public R<List<TInsuranceTypeStandard>> getInsuranceTypeStandardList(String riskId) {
		return insuranceTypeStandardService.getInsuranceTypeStandardList(riskId);
	}
	/**
	 * 删除购买标准信息
	 * @param id 购买标准id
	 * @return R
	 */
	@Operation(summary = "删除购买标准信息", description = "删除购买标准信息：hasPermission('demo_insuranceTypeStandard_delete')")
	@DeleteMapping("/{id}" )
	//@PreAuthorize("@pms.hasPermission('demo_insuranceTypeStandard_delete')" )
	public R deleteById(@PathVariable("id" ) String id) {
		return insuranceTypeStandardService.deleteInsuranceTypeStandard(id);
	}

	/**
	 * 新增购买标准
	 * @param insuranceTypeStandard 购买标准
	 * @return R
	 */
	@Operation(summary = "新增购买标准", description = "新增购买标准：hasPermission('demo_insuranceTypeStandard_add')")
	@SysLog("新增购买标准" )
	@PostMapping("/save")
	//@PreAuthorize("@pms.hasPermission('demo_insuranceTypeStandard_add')" )
	public R save(@RequestBody TInsuranceTypeStandard insuranceTypeStandard) {
		return insuranceTypeStandardService.saveInsuranceTypeStandard(insuranceTypeStandard);
	}

	/**
	 * @Author fxj
	 * @Description 更新启用禁用状态
	 * @param id 购买标准id
	 * @param enable 启用禁用状态
	 * @Date 19:00 2025/4/7
	**/
	@Operation(summary = "通过id更新启用状态", description = "通过id更新启用状态")
	@PostMapping("/enableById" )
	public R enableById(@RequestParam(value = "id",required = true ) String id,
						@RequestParam(value = "enable",required = true ) String enable) {
		return insuranceTypeStandardService.enableById(id, enable);
	}
}
