package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceWarnService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceSearchVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TBusinessInsuranceVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author fxj
 * @Date 2023/2/16
 * @Description 商险提醒相关
 * @Version 1.0
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceWarn")
@Tag(name = "商险提醒相关")
public class TInsurancesWarnController {
	@Resource
	private TInsuranceDetailService insuranceDetailService;

	@Resource
	private TInsuranceWarnService insuranceWarnService;

	/**
	 * @Author fxj
	 * @Description 商险到期提醒分页查询
	 * @Date 16:51 2023/2/16
	**/
	@Operation(description = "商险到期提醒分页查询")
	@GetMapping("/getExpireWarn/Vopage")
	public R<IPage<TBusinessInsuranceVo>> getTBusinessInsuranceExpireWarnVoPage(Page<TBusinessInsuranceVo> page, InsuranceSearchVo tBusinessInsurance) {
		return R.ok(insuranceDetailService.getInsuranceExpireWarnVoPage(page, tBusinessInsurance));
	}

	/**
	 * @Author fxj
	 * @Description 备注批量导入
	 * @Date 16:57 2023/2/16
	**/
	@SneakyThrows
	@Operation(description = "备注批量导入(wxhr:insurance_Warn_batch_update)")
	@SysLog("备注批量导入")
	@PostMapping("/remark/batchAdd")
	//@PreAuthorize("@pms.hasPermission('insurance_Warn_batch_update')")
	public R<List<ErrorMessage>> remarkBatchAdd(@RequestBody MultipartFile file) {
		return insuranceDetailService.remarkBatchAdd(file.getInputStream());
	}

	/**
	 * @Author fxj
	 * @Description 商险到期提醒分页查询导出
	 * @Date 16:57 2023/2/16
	**/
	@PostMapping("/getExpireWarn/export")
	@Operation(description = "商险到期提醒分页查询导出 hasPermission('wxhr:insurance_expirewarnexport')")
	@SysLog("商险到期提醒分页查询导出")
	//@PreAuthorize("@pms.hasPermission('wxhr:insurance_expirewarnexport')")
	public void getExpireWarnExport(HttpServletResponse response, HttpServletRequest request, @RequestBody InsuranceSearchVo vo) {
		insuranceDetailService.exportInsurancesWarn(vo, response,vo.getExportFields(),vo.getIdStr());
	}

	/**
	 * @Author fxj
	 * @Description 到期提醒备注
	 * @Date 17:01 2023/2/16
	**/
	@Operation(description = "到期提醒备注")
	@SysLog("到期提醒备注")
	@PutMapping("/expireRemark")
	public R<Object> expireRemark(@RequestBody TBusinessInsuranceVo vo) {
		return insuranceDetailService.expireRemark(vo);
	}

	/**
	 * @Author fxj
	 * @Description 到期提醒忽略
	 * @Date 17:01 2023/2/16
	**/
	@Operation(description = "到期提醒忽略(wxhr:insurance_expireignore)")
	@SysLog("到期提醒忽略")
	@PutMapping("/expireIgnore")
	@PreAuthorize("@pms.hasPermission('wxhr:insurance_expireignore')")
	public R<Object> expireIgnore(@RequestBody TBusinessInsuranceVo vo) {
		return insuranceDetailService.expireIgnore(vo);
	}

	/**
	 * @Author fxj
	 * @Description 到期提醒批量忽略
	 * @Date 17:06 2023/2/16
	**/
	@Operation(description = "到期提醒批量忽略(wxhr:insurance_expireignore)")
	@SysLog("到期提醒批量忽略")
	@PutMapping("/batchexpireIgnore")
	@PreAuthorize("@pms.hasPermission('wxhr:insurance_expireignore')")
	public R<Object> batchexpireIgnore(@RequestBody List<String> ids) {
		return insuranceDetailService.batchexpireIgnore(ids);
	}

	/**
	 * @Author fxj
	 * @Description  工作台消息提醒：商险到期总数通知提醒
	 * @Date 17:03 2023/2/16
	**/
    @Operation(description = "商险到期总数通知提醒")
	@PostMapping("/workBranch/getWorkBanchInsuranceMessageWarn")
	public R<Integer> getExpireInsuranceWarn() {
		return insuranceDetailService.getExpireInsuranceWarn();
	}

	@Operation(description = "商险到期个人总数提醒")
	@PostMapping("/getUserInsuranceMessageWarnCount")
	public R<Integer> getUserInsuranceMessageWarnCount(@RequestParam String userName) {
		return insuranceDetailService.getUserInsuranceMessageWarnCount(userName);
	}

	@Operation(description = "每天刷新商险到期提醒信息")
	@Inner
	@PostMapping("/inner/createInsuranceAlert")
	public void createInsuranceAlert() {
		insuranceWarnService.createInsuranceAlert();
	}
}
