package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EmployeePreLogListVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsurancePreSearchVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsurancePreVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsuranceSelectVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
public interface TEmployeeInsurancePreService extends IService<TEmployeeInsurancePre> {
    /**
     * 商险待办任务表简单分页查询
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return
     */
    IPage<TEmployeeInsurancePre> getTEmployeeInsurancePrePage(Page<TEmployeeInsurancePre> page, TEmployeeInsurancePreSearchVo tEmployeeInsurancePre);

	/**
	 * 商险待办任务表导出
	 * @param searchVo 商险待办任务表
	 * @return
	 */
    void listExport(HttpServletResponse response, TEmployeeInsurancePreSearchVo searchVo);

	/**
	 * 商险派单信息单个/批量确认
	 * @param idList id集合
	 * @return
	 */
    R confirm(List<String> idList);

	/**
	 * 商险派单信息批量派单
	 * @param idList id集合
	 * @return
	 */
	R batchDispatcherInsurance(List<String> idList);

	/**
	 * 新增商险待购买信息
	 * @param preVo
	 * @return
	 */
	Boolean saveInsurancePreInfo(EmployeeRegistrationPreVo preVo);

	/**
	 * 更新商险待购买状态
	 * @param id
	 * @param status 状态
	 * @return
	 */
	void updateInsurancePreInfo(String id,String status);

	TEmployeeInsuranceSelectVo selectInsurancePreInfoList(TEmployeeInsurancePreVo preVo);

	void updateInsurancePreCustomerName(EmployeeRegistrationCustomerUserUpdateVo updateVo);

	void pushWxConfrimMessage();

	/**
	 * @Description: 查询list
	 * @Author: hgw
	 * @Date: 2025/4/8 11:31
	 * @return: com.yifu.cloud.plus.v1.yifu.insurances.vo.EmployeePreLogListVo
	 **/
	EmployeePreLogListVo getListByEmpPreId(String empPreId);

	/**
	 * @Description: 先删后增
	 * @Author: hgw
	 * @Date: 2025/4/8 11:31
	 * @return: boolean
	 **/
	boolean saveOrUpdateInsuranceList(List<TEmployeeInsurancePre> preList);

}
