package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceOperate;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceCompanyMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceCompanyService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceOperateService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_company(保险公司表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:09
*/
@Service
public class TInsuranceCompanyServiceImpl extends ServiceImpl<TInsuranceCompanyMapper, TInsuranceCompany> implements TInsuranceCompanyService {


	@Resource
	private TInsuranceDetailService tInsuranceDetailService;

	@Resource
	private TInsuranceOperateService tInsuranceOperateService;

	/**
	 * 分页查询保险公司
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param insuranceCompany 查询类
	 * @return {@link IPage<TInsuranceCompany>}
	 */
	@Override
	public IPage<TInsuranceCompany> pageDiy(Page page, TInsuranceCompany insuranceCompany) {
		IPage<TInsuranceCompany> list = this.baseMapper.getInsuranceCompanyListPage(page, insuranceCompany);
		return list;
	}

	/**
	 * 新增保险公司
	 *
	 * @author zhaji
	 * @param insuranceCompany 新增类
	 * @return {@link R}
	 */
	@Override
	public R saveInsuranceCompany(TInsuranceCompany insuranceCompany) {
		if(Common.isEmpty(insuranceCompany)){
			return R.failed(InsurancesConstants.NEW_COMPANY_IS_EMPTY);
		}
		YifuUser user = SecurityUtils.getUser();
		String billingType = insuranceCompany.getBillingType();
		if (!CommonConstants.ZERO_STRING.equals(billingType) && !CommonConstants.ONE_STRING.equals(billingType)){
			return R.failed(InsurancesConstants.COMPANY_BILLING_TYPE_IS_ERROR);
		}
		if (!ValidityUtil.validate60(insuranceCompany.getCompanyName())){
			return R.failed(InsurancesConstants.COMPANY_NAME_IS_ERROR);
		}
		if (!ValidityUtil.validate50(insuranceCompany.getCompanyAddress())){
			return R.failed(InsurancesConstants.COMPANY_ADDRESS_IS_ERROR);
		}
		boolean b = companyIsExists(insuranceCompany.getCompanyName());
		if (!b){
			insuranceCompany.setCreateBy(user.getId());
			insuranceCompany.setCreateName(user.getNickname());
			insuranceCompany.setCreateTime(LocalDateTime.now());
			insuranceCompany.setDeleteFlag(CommonConstants.ZERO_INT);
			save(insuranceCompany);
			addOperate(insuranceCompany,user, InsurancesConstants.NEW_INSURANCE_COMPANY);
			return R.ok(InsurancesConstants.NEW_COMPANY_SUCCESS);
		}else{
			return R.failed(InsurancesConstants.COMPANY_NAME_IS_USE);
		}
	}

	/**
	 * 修改保险公司
	 *
	 * @author zhaji
	 * @param insuranceCompany 修改类
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R updateInsuranceCompany(TInsuranceCompany insuranceCompany) {
		YifuUser user = SecurityUtils.getUser();
		String id = insuranceCompany.getId();
		if (StringUtils.isEmpty(id)){
			return R.failed(InsurancesConstants.UPDATE_COMPANY_ID_IS_EMPTY);
		}
		String billingType = insuranceCompany.getBillingType();
		if (!CommonConstants.ZERO_STRING.equals(billingType) && !CommonConstants.ONE_STRING.equals(billingType)){
			return R.failed(InsurancesConstants.COMPANY_BILLING_TYPE_IS_ERROR);
		}
		if (!ValidityUtil.validate50(insuranceCompany.getCompanyAddress())){
			return R.failed(InsurancesConstants.COMPANY_ADDRESS_IS_ERROR);
		}
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getId,id).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if (Common.isEmpty(one)){
			return R.failed(InsurancesConstants.COMPANY_IS_DELETE);
		}
		String companyName = one.getCompanyName();
		String newCompanyName = insuranceCompany.getCompanyName();
		if (!ValidityUtil.validate60(newCompanyName)){
			return R.failed(InsurancesConstants.CHANGE_COMPANY_NAME_IS_ERROR);
		}
		//如果当前保险公司名称和修改后的名称不同
		if (!companyName.equals(insuranceCompany.getCompanyName())){
			//校验旧的保险公司名称是否已存在对应的商险信息
			LambdaQueryWrapper<TInsuranceDetail> detailQueryWrapper = new LambdaQueryWrapper<>();
			detailQueryWrapper.eq(TInsuranceDetail::getInsuranceCompanyName,companyName)
					.eq(TInsuranceDetail::getDeleteFlag,CommonConstants.ZERO_INT);
			List<TInsuranceDetail> list = tInsuranceDetailService.list(detailQueryWrapper);
			if (Common.isNotEmpty(list)){
				return R.failed(InsurancesConstants.COMPANY_IS_USED);
			}else{
				//校验新的保险公司名称在数据库中是否存在
				boolean b = companyIsExists(insuranceCompany.getCompanyName());
				if(b){
					return R.failed(InsurancesConstants.COMPANY_NAME_IS_USE);
				}else {
					insuranceCompany.setUpdateBy(user.getId());
					insuranceCompany.setUpdateTime(LocalDateTime.now());
					updateById(insuranceCompany);
					addOperate(insuranceCompany,user, InsurancesConstants.NEW_INSURANCE_COMPANY);
					return R.ok(InsurancesConstants.UPDATE_COMPANY_SUCCESS);
				}
			}
		}else{
			insuranceCompany.setUpdateBy(user.getId());
			insuranceCompany.setUpdateTime(LocalDateTime.now());
			updateById(insuranceCompany);
			addOperate(insuranceCompany,user, InsurancesConstants.UPDATE_INSURANCE_COMPANY);
			return R.ok(InsurancesConstants.UPDATE_COMPANY_SUCCESS);
		}
	}
	/**
	 * 删除保险公司信息
	 *
	 * @author zhaji
	 * @param id 保险公司id
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R deleteById(String id) {
		YifuUser user = SecurityUtils.getUser();
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getId,id).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if(Common.isEmpty(one)){
			return R.failed("当前保险公司不存在");
		}else {
			LambdaUpdateWrapper<TInsuranceCompany> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(TInsuranceCompany::getId,id)
						 .set(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT)
						 .set(TInsuranceCompany :: getUpdateBy,user.getId())
						 .set(TInsuranceCompany :: getUpdateTime,LocalDateTime.now());
			update(updateWrapper);
			addOperate(one,user, InsurancesConstants.DELETE_INSURANCE_COMPANY);
			return R.ok("删除成功");
		}
	}

	/**
	 * 操作记录
	 *
	 * @author zhaji
	 * @param insuranceCompany 保险公司
	 * @param user 登录用户
	 * @param operateDesc 操作描述
	 * @return void
	 */
	private void addOperate(TInsuranceCompany insuranceCompany,YifuUser user,String operateDesc){
		try {
			TInsuranceOperate operate = new TInsuranceOperate();
			operate.setInsuranceDetailId(insuranceCompany.getId());
			operate.setOperateDesc(operateDesc);
			operate.setCreateBy(user.getId());
			operate.setCreateName(user.getNickname());
			operate.setCreateTime(LocalDateTime.now());
			tInsuranceOperateService.save(operate);
		}catch (Exception e){
				e.getStackTrace();
		}
	}


	/**
	 * 查询当前保险公司列表
	 *
	 * @author zhaji
	 * @return {@link List< TInsuranceCompany>}
	 */
	@Override
	public List<TInsuranceCompany> getInsuranceCompanyList() {
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		return list(queryWrapper);
	}

	/**
	 * 校验保险公司是否存在
	 *
	 * @author zhaji
	 * @param companyName 保险公司名称
	 * @return {@link boolean}
	 */
	public boolean companyIsExists(String companyName){
		LambdaQueryWrapper<TInsuranceCompany> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceCompany::getCompanyName,companyName).eq(TInsuranceCompany::getDeleteFlag, CommonConstants.ZERO_INT);
		TInsuranceCompany one = this.getOne(queryWrapper);
		if(Common.isEmpty(one)){
			return false;
		}else{
			return true;
		}
	}
}
