package com.yifu.cloud.plus.v1.permission.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysUserInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSaveVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysuserinfo")
@Tag(name = "新权限-账号管理表管理")
public class SysUserInfoController {

	private final SysUserInfoService sysUserInfoService;


	/**
	 * 简单分页查询
	 *
	 * @param page        分页对象
	 * @param sysUserInfo 新权限-账号管理表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysUserInfo>> getSysUserInfoPage(Page<SysUserInfo> page, SysUserInfoSearchVo sysUserInfo) {
		return new R<>(sysUserInfoService.getSysUserInfoPage(page, sysUserInfo));
	}

	/**
	 * 不分页查询
	 *
	 * @param sysUserInfo 新权限-账号管理表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('ekp_sysuserinfo_get')" )
	public R<List<SysUserInfo>> getSysUserInfoNoPage(@RequestBody SysUserInfoSearchVo sysUserInfo) {
		return R.ok(sysUserInfoService.noPageDiy(sysUserInfo));
	}

	/**
	 * 通过id查询新权限-账号管理表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{fdId}")
	public R<SysUserInfoSaveVo> getById(@PathVariable("fdId") String fdId) {
		return sysUserInfoService.getInfoById(fdId);
	}

	/**
	 * 新增新权限-账号管理表
	 *
	 * @param vo 新权限-账号管理表
	 * @return R
	 */
	@Operation(summary = "新增或编辑新权限-账号管理表", description = "新增或编辑新权限-账号管理表：hasPermission('ekp_sysuserinfo_add')")
	@SysLog("新增或编辑新权限-账号管理表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysuserinfo_add')")
	public R<String> saveOrUpdateUserInfo(@RequestBody SysUserInfoSaveVo vo) {
		return sysUserInfoService.saveOrUpdateUserInfo(vo);
	}

	/**
	 * 修改新权限-账号管理表
	 *
	 * @param sysUserInfo 新权限-账号管理表
	 * @return R
	 */
	@Operation(summary = "修改新权限-账号管理表", description = "修改新权限-账号管理表：hasPermission('ekp_sysuserinfo_edit')")
	@SysLog("修改新权限-账号管理表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysuserinfo_edit')")
	public R<Boolean> updateById(@RequestBody SysUserInfo sysUserInfo) {
		return R.ok(sysUserInfoService.updateById(sysUserInfo));
	}

	/**
	 * 通过id删除新权限-账号管理表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id删除新权限-账号管理表", description = "通过id删除新权限-账号管理表：hasPermission('ekp_sysuserinfo_del')")
	@SysLog("通过id删除新权限-账号管理表")
	@DeleteMapping("/{fdId}")
	@PreAuthorize("@pms.hasPermission('ekp_sysuserinfo_del')")
	public R<Boolean> removeById(@PathVariable String fdId) {
		return R.ok(sysUserInfoService.removeById(fdId));
	}

	/**
	 * @Description: 手动同步并更新账号信息
	 * @Author: hgw
	 * @Date: 2023/9/5 16:14
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "手动同步并更新账号信息", description = "手动同步并更新账号信息")
	@SysLog("手动同步并更新账号信息")
	@PostMapping("/startRefreshEkpUser")
	public R<String> startRefreshEkpUser() {
		sysUserInfoService.doRefreshEkpUser();
		return R.ok();
	}

	/**
	 * @param
	 * @Description: 定时任务-自动同步并更新账号信息
	 * @Author: hgw
	 * @Date: 2023/9/4 16:07
	 * @return: void
	 **/
	@Inner
	@Operation(description = "定时任务-自动同步并更新账号信息")
	@PostMapping("/inner/doRefreshEkpUser")
	public void doRefreshEkpUser() {
		sysUserInfoService.doRefreshEkpUser();
	}

	/**
	 * @Description: 手动同步并更新账号信息
	 * @Author: hgw
	 * @Date: 2023/9/5 16:14
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(summary = "测试权限sql", description = "测试权限sql")
	@SysLog("测试权限sql")
	@PostMapping("/testPermission")
	public R<String> testPermission(@RequestParam String modelId, @RequestParam(required = false) String userId) {
		return R.ok(sysUserInfoService.testPermission(modelId, userId));
	}

	/**
	 * 简单分页查询
	 * hyc 2023-9-11 15:25:50
	 * @param page        分页对象
	 * @param name 新权限-账号管理表
	 * @return
	 */
	@Operation(description = "根据编码或者登录名简单分页查询")
	@GetMapping("/getUserByCodeOrLoginName")
	public R<IPage<SysUserInfo>> getUserByCodeOrLoginName(Page<SysUserInfo> page, String name) {
		return new R<>(sysUserInfoService.getUserByCodeOrLoginName(page, name));
	}
}
