package com.yifu.cloud.plus.v1.yifu.process.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodePrimission;
import com.yifu.cloud.plus.v1.yifu.process.mapper.TNodePrimissionMapper;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodePrimissionService;
import org.springframework.stereotype.Service;

/**
 * 流程处理权限表（允许多个，多个代表有主办和经办）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Service
public class TNodePrimissionServiceImpl extends ServiceImpl<TNodePrimissionMapper, TNodePrimission> implements TNodePrimissionService {

     /**
      * 流程处理权限表（允许多个，多个代表有主办和经办）简单分页查询
      *
      * @param tNodePrimission 流程处理权限表（允许多个，多个代表有主办和经办）
      * @return
      */
     @Override
     public IPage<TNodePrimission> getTNodePrimissionPage(Page<TNodePrimission> page, TNodePrimission tNodePrimission) {
          return baseMapper.getTNodePrimissionPage(page, tNodePrimission);
     }

     /**
      * @param processId 流程id
      * @Description: 删除
      * @Author: hgw
      * @Date: 2020-7-22 17:02:34
      * @return: int
      **/
     @Override
     public int deleteByProcessId(String processId) {
          return baseMapper.deleteByProcessId(processId);
     }

}
