package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 审批抄送记录信息表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Data
@TableName("t_audit_copy_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "审批抄送记录信息表")
public class TAuditCopyInfo extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	@NotBlank(message = "抄送人id不能为空")
	@Length(max = 32, message = "抄送人id不能超过32个字符")
	@Schema(description = "抄送人id")
	private String auditUserId;

	@NotBlank(message = "抄送人姓名不能为空")
	@Length(max = 32, message = "抄送人姓名不能超过32个字符")
	@Schema(description = "抄送人姓名")
	private String auditUser;

	@Length(max = 32, message = "实体id不能超过32个字符")
	@Schema(description = "实体id")
	private String domainId;

	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	@Length(max = 32, message = "流程id不能超过32个字符")
	@Schema(description = "流程id")
	private String flowId;

	@Length(max = 32, message = "节点id不能超过32个字符")
	@Schema(description = "节点id")
	private String nodeId;

	@Length(max = 1, message = "删除表示 0未删除 1删除不能超过1个字符")
	@Schema(description = "删除表示 0未删除 1删除")
	@TableLogic
	private String deleteFlag;

	@Length(max = 50, message = "节点名称不能超过50个字符")
	@Schema(description = "节点名称")
	private String nodeName;

	@Length(max = 2, message = "审核类型 0不购买商险审核不能超过2个字符")
	@Schema(description = "审核类型 0不购买商险审核")
	private String auditType;

	@Length(max = 1, message = "之前审核记录标识 不能超过1个字符")
	@Schema(description = "之前审核记录标识 0之前记录 1当前审核记录。用于当前审核流程过滤判断")
	private String preFlag;

	@Length(max = 32, message = "提交人id不能超过32个字符")
	@Schema(description = "提交人id")
	private String submitMan;

	@Length(max = 32, message = "提交人姓名不能超过32个字符")
	@Schema(description = "提交人姓名")
	private String submitManName;

	@Schema(description = "提交时间")
	private LocalDateTime submitCreateTime;

}
