/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TDeptSee;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TDeptSeeMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TDeptSeeService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TDeptSeeSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目薪资查询权限配置表-薪资配置1
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Log4j2
@Service
public class TDeptSeeServiceImpl extends ServiceImpl<TDeptSeeMapper, TDeptSee> implements TDeptSeeService {
	/**
	 * 项目薪资查询权限配置表-薪资配置1简单分页查询
	 *
	 * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
	 * @return
	 */
	@Override
	public IPage<TDeptSee> getTDeptSeePage(Page<TDeptSee> page, TDeptSeeSearchVo tDeptSee) {
		return baseMapper.getTDeptSeePage(page, tDeptSee);
	}


	@Override
	public List<TDeptSee> noPageDiy(TDeptSeeSearchVo searchVo) {
		LambdaQueryWrapper<TDeptSee> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TDeptSee::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private Long noPageCountDiy(TDeptSeeSearchVo searchVo) {
		LambdaQueryWrapper<TDeptSee> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TDeptSee::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TDeptSeeSearchVo entity) {
		LambdaQueryWrapper<TDeptSee> wrapper = Wrappers.lambdaQuery();
		if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
			wrapper.ge(TDeptSee::getCreateTime, entity.getCreateTimes()[0])
					.le(TDeptSee::getCreateTime,
							entity.getCreateTimes()[1]);
		}
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TDeptSee::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
