/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Description: 自定义sql与菜单的关联表
 * @Author: hgw
 * @Date: 2022-6-8 17:07:44
 * @return:
 **/
@Schema(description = "自定义sql与菜单的关联表")
@Data
public class SysDiySqlMenuRel implements Serializable {

	private static final long serialVersionUID = 1L;

	@TableId(value = "id", type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 数据权限表id
	 */
	@NotBlank(message = "数据权限表id不能为空")
	@Schema(description = "数据权限表id", required = true)
	private String sysDataAuthId;

	/**
	 * SysDataAuthDiySql表的id
	 */
	@NotBlank(message = "自定义sql表id不能为空")
	@Schema(description = "自定义sql表id", required = true)
	private String sysDiySqlId;

	/**
	 * 菜单id
	 */
	@NotBlank(message = "菜单id不能为空")
	@Schema(description = "菜单id", required = true)
	private String menuId;

}
