/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 社保购买规则明细表
 *
 * @author fxj
 * @date 2025-10-09 11:13:18
 */
@Data
public class TAutoSocialRuleRelVo extends RowIndex implements Serializable {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键ID 不能为空")
	@Length(max = 32, message = "主键ID 不能超过32 个字符")
	@ExcelAttribute(name = "主键ID", isNotEmpty = true, errorInfo = "主键ID 不能为空", maxLength = 32)
	@Schema(description = "主键ID")
	@ExcelProperty("主键ID")
	private String id;
	/**
	 * 社保配置ID
	 */
	@NotBlank(message = "社保配置ID 不能为空")
	@Length(max = 32, message = "社保配置ID 不能超过32 个字符")
	@ExcelAttribute(name = "社保配置ID", isNotEmpty = true, errorInfo = "社保配置ID 不能为空", maxLength = 32)
	@Schema(description = "社保配置ID")
	@ExcelProperty("社保配置ID")
	private String mainId;
	/**
	 * 配置名称
	 */
	@NotBlank(message = "配置名称 不能为空")
	@Length(max = 50, message = "配置名称 不能超过50 个字符")
	@ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称 不能为空", maxLength = 50)
	@Schema(description = "配置名称")
	@ExcelProperty("配置名称")
	private String configName;
	/**
	 * 社保户ID
	 */
	@Length(max = 50, message = "社保户ID 不能超过50 个字符")
	@ExcelAttribute(name = "社保户ID", maxLength = 50)
	@Schema(description = "社保户ID")
	@ExcelProperty("社保户ID")
	private String configHouseId;
	/**
	 * 社保起缴日期是否一致(0-是,1-否)
	 */
	@Length(max = 1, message = "社保起缴日期是否一致(0-是,1-否) 不能超过1 个字符")
	@ExcelAttribute(name = "社保起缴日期是否一致(0-是,1-否)", maxLength = 1)
	@Schema(description = "社保起缴日期是否一致(0-是,1-否)")
	@ExcelProperty("社保起缴日期是否一致(0-是,1-否)")
	private String socialDateFlag;
	/**
	 * 起缴日期：0 入职日期
	 */
	@Length(max = 2, message = "起缴日期：0 入职日期 不能超过2 个字符")
	@ExcelAttribute(name = "起缴日期：0 入职日期", maxLength = 2)
	@Schema(description = "起缴日期：0 入职日期")
	@ExcelProperty("起缴日期：0 入职日期")
	private String socialDateType;
	/**
	 * 缴纳类型：0最低、1自定义、2最高
	 */
	@Length(max = 2, message = "缴纳类型：0最低、1自定义、2最高 不能超过2 个字符")
	@ExcelAttribute(name = "缴纳类型：0最低、1自定义、2最高", maxLength = 2)
	@Schema(description = "缴纳类型：0最低、1自定义、2最高")
	@ExcelProperty("缴纳类型：0最低、1自定义、2最高")
	private String paymentType;
	/**
	 * 备案基数类型：0固定值1自定义
	 */
	@Length(max = 2, message = "备案基数类型：0固定值1自定义 不能超过2 个字符")
	@ExcelAttribute(name = "备案基数类型：0固定值1自定义", maxLength = 2)
	@Schema(description = "备案基数类型：0固定值1自定义")
	@ExcelProperty("备案基数类型：0固定值1自定义")
	private String recordBaseType;
	/**
	 * 备案基数
	 */
	@Length(max = 30, message = "备案基数 不能超过30 个字符")
	@ExcelAttribute(name = "备案基数", maxLength = 30)
	@Schema(description = "备案基数")
	@ExcelProperty("备案基数")
	private String recordBase;
	/**
	 * 委托备注（字典值）
	 */
	@Length(max = 100, message = "委托备注（字典值） 不能超过100 个字符")
	@ExcelAttribute(name = "委托备注（字典值）", maxLength = 100)
	@Schema(description = "委托备注（字典值）")
	@ExcelProperty("委托备注（字典值）")
	private String remarkDict;
	/**
	 * 项目编码
	 */
	@NotBlank(message = "项目编码 不能为空")
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码 不能为空", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@NotBlank(message = "项目ID 不能为空")
	@Length(max = 50, message = "项目ID 不能超过50 个字符")
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID 不能为空", maxLength = 50)
	@Schema(description = "项目ID")
	@ExcelProperty("项目ID")
	private String deptId;

}
