package com.yifu.cloud.plus.v1.business.entity.vacation;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 假勤信息表
 * @TableName t_vacation_info
 */
@TableName(value ="t_vacation_info")
@Data
public class TVacationInfo implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * b端员工工号
     */
    private String businessTelecomNumber;

    /**
     * 人员姓名
     */
    private String empName;

    /**
     * 身份证号码
     */
    private String empIdcard;

    /**
     * 部门id
     */
    private Integer departId;

    /**
     * b端岗位
     */
    private String businessPost;

    /**
     * 假勤类型（字典值）
     */
    private String vacationType;

    /**
     * 假勤开始时间
     */
    private LocalDateTime vacationStartTime;

    /**
     * 假勤结束时间
     */
    private LocalDateTime vacationEndTime;

    /**
     * 假勤时长
     */
    private BigDecimal vacationDuration;

    /**
     * 假勤实际结束时间
     */
    private LocalDateTime acturalVacationEndTime;

    /**
     * 假勤事由
     */
    private String vacationReason;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 创建人id
     */
    private String createUserId;

    /**
     * 更新人id
     */
    private String updateUserId;

    /**
     * 假勤状态 0待休 1休假中 2到期待销假 3已销假
     */
    private String vacationStatus;

    /**
     * 销假说明
     */
    private String vacationNote;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 年假未休时长
     */
    private BigDecimal vacationNotUsedDuration;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}