package com.yifu.cloud.plus.v1.yifu.permission.entity;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 新权限-角色-菜单-关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
@TableName("sys_role_menu_res")
@Schema(description = "新权限-角色-菜单-关联表")
public class SysRoleMenuRes {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 角色ID
	 */
	@ExcelAttribute(name = "角色ID", isNotEmpty = true, errorInfo = "角色ID不能为空", maxLength = 36)
	@NotBlank(message = "角色ID不能为空")
	@Length(max = 36, message = "角色ID不能超过36个字符")
	@ExcelProperty("角色ID")
	@Schema(description = "角色ID")
	private String roleId;
	/**
	 * 菜单ID
	 */
	@ExcelAttribute(name = "菜单ID", isNotEmpty = true, errorInfo = "菜单ID不能为空", maxLength = 36)
	@NotBlank(message = "菜单ID不能为空")
	@Length(max = 36, message = "菜单ID不能超过36个字符")
	@ExcelProperty("菜单ID")
	@Schema(description = "菜单ID")
	private String menuId;

}
