/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsLabor;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 本期劳务费申报表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Mapper
public interface TStatisticsLaborMapper extends BaseMapper<TStatisticsLabor> {
    /**
     * 本期劳务费申报表简单分页查询
     * @param tStatisticsLabor 本期劳务费申报表
     * @return
     */
    IPage<TStatisticsLabor> getTStatisticsLaborPage(Page<TStatisticsLabor> page, @Param("tStatisticsLabor") TStatisticsLabor tStatisticsLabor);

	/**
	 * @param
	 * @Description: 统计
	 * @return:
	 **/
	List<TStatisticsLabor> doStatisticsLabor(@Param("nowMonth") String nowMonth, @Param("lastMonth") String lastMonth);
}
