/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 社保公积金户权限配置表
 *
 * @author huyc
 * @date 2022-11-02 09:13:07
 */
@Data
@TableName("t_socialfund_house_res")
@EqualsAndHashCode()
@Schema(description = "社保公积金户权限配置表")
public class TSocialfundHouseRes {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	@TableField(exist = false)
	private List<String> idList;
	/**
	 * 登录人id
	 */
	@ExcelAttribute(name = "审核人id", maxLength = 32)
	@Length(max = 32, message = "审核人id不能超过32个字符")
	@ExcelProperty("审核人id")
	@Schema(description = "审核人id")
	private String userId;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Length(max = 50, message = "社保户不能超过50个字符")
	@ExcelProperty("社保户")
	@Schema(description = "社保户")
	private String socialHousehold;
	/**
	 * 公积金户
	 */
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Length(max = 50, message = "公积金户不能超过50个字符")
	@ExcelProperty("公积金户")
	@Schema(description = "公积金户")
	private String fundHousehold;
	/**
	 * 被授权时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "被授权时间")
	@TableField(fill = FieldFill.INSERT)
	private LocalDateTime createTime;
	/**
	 * 授权人
	 */
	@ExcelAttribute(name = "授权人", maxLength = 32)
	@ExcelProperty("授权人")
	@Schema(description = "授权人")
	@TableField(fill = FieldFill.INSERT)
	private String createBy;
	/**
	 * 状态0启用1禁用
	 */
	@ExcelAttribute(name = "状态0启用1禁用", maxLength = 1)
	@Length(max = 1, message = "状态0启用1禁用不能超过1个字符")
	@ExcelProperty("状态0启用1禁用")
	@Schema(description = "状态0启用1禁用")
	private String status;
	/**
	 * 审核人姓名
	 */
	@ExcelAttribute(name = "审核人姓名", maxLength = 32)
	@Length(max = 32, message = "审核人姓名不能超过32个字符")
	@ExcelProperty("审核人姓名")
	@Schema(description = "审核人姓名")
	private String userName;
	/**
	 * 所在部门
	 */
	@ExcelAttribute(name = "所在部门", maxLength = 32)
	@Length(max = 32, message = "所在部门不能超过32个字符")
	@ExcelProperty("所在部门")
	@Schema(description = "所在部门")
	private String userDeptName;
	/**
	 * 户类型 0社保户1公积金户
	 */
	@ExcelAttribute(name = "户类型 0社保户1公积金户", maxLength = 1)
	@ExcelProperty("户类型 0社保户1公积金户")
	@Schema(description = "户类型 0社保户1公积金户")
	private String houseNameType;	/**
	 * 权限类型 0审核1办理
	 */
	@ExcelAttribute(name = "权限类型 0审核1办理", maxLength = 1)
	@ExcelProperty("权限类型 0审核1办理")
	@Schema(description = "权限类型 0审核1办理")
	private String authType;


}
