package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author fxj
 * @Date 2025/10/11
 * @Description
 * @Version 1.0
 */
@Data
public class SysBaseSetSocialExportVo implements Serializable {

	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户")
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String departName;
	/**
	 * 社保缴纳地
	 */
	@ExcelAttribute(name = "社保缴纳地")
	@Schema(description = "社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地")
	private String province;
	/**
	 * 0.在用1.终止2过期
	 */
	@ExcelAttribute(name = "状态",readConverterExp = "0=在用,1=终止,2=过期")
	@Schema(description = "状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("状态")
	private String status;
	/**
	 * 适用周期
	 */
	@ExcelAttribute(name = "适用周期")
	@Schema(description = "适用周期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("适用周期")
	private String applyStartDate;
	/**
	 * 执行月份
	 */
	@ExcelAttribute(name = "执行月份")
	@Schema(description = "执行月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("执行月份")
	private String doMonth;

	/**
	 * 是否同一基数上下限:  0是；1否
	 */
	@ExcelAttribute(name = "是否同一基数上下限",readConverterExp = "0=是,1=否")
	@Schema(description = "是否同一基数上下限: 0是；1否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否同一基数上下限")
	private String isSameBase;

	/**
	 * 养老基数下限
	 */
	@ExcelAttribute(name = "养老基数下限")
	@Schema(description = "养老基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数下限")
	private BigDecimal lowerPersion;

	/**
	 * 养老基数上限
	 */
	@ExcelAttribute(name = "养老基数上限")
	@Schema(description = "养老基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数上限")
	private BigDecimal upPersion;

	/**
	 * 工伤基数下限
	 */
	@ExcelAttribute(name = "工伤基数下限")
	@Schema(description = "工伤基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数下限")
	private BigDecimal lowerInjury;

	/**
	 * 工伤基数上限
	 */
	@ExcelAttribute(name = "工伤基数上限")
	@Schema(description = "工伤基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数上限")
	private BigDecimal upInjury;

	/**
	 * 医疗基数下限
	 */
	@ExcelAttribute(name = "医疗基数下限")
	@Schema(description = "医疗基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数下限")
	private BigDecimal lowerMedical;

	/**
	 * 医疗基数上限
	 */
	@ExcelAttribute(name = "医疗基数上限")
	@Schema(description = "医疗基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数上限")
	private BigDecimal upMedical;

	/**
	 * 生育基数下限
	 */
	@ExcelAttribute(name = "生育基数下限")
	@Schema(description = "生育基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数下限")
	private BigDecimal lowerBirth;

	/**
	 * 生育基数上限
	 */
	@ExcelAttribute(name = "生育基数上限")
	@Schema(description = "生育基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数上限")
	private BigDecimal upBirth;

	/**
	 * 失业基数下限
	 */
	@ExcelAttribute(name = "失业基数下限")
	@Schema(description = "失业基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数下限")
	private BigDecimal lowerUnemployment;

	/**
	 * 失业基数上限
	 */
	@ExcelAttribute(name = "失业基数上限")
	@Schema(description = "失业基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数上限")
	private BigDecimal upUnemployment;

	/**
	 * 大病基数下限
	 */
	@ExcelAttribute(name = "大病基数下限")
	@Schema(description = "大病基数下限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病基数下限")
	private BigDecimal lowerBig;

	/**
	 * 大病基数上限
	 */
	@ExcelAttribute(name = "大病基数上限",isDouble = true)
	@Schema(description = "大病基数上限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病基数上限")
	private BigDecimal upBig;

	/**
	 * 是否大病:  0收取；1不收取
	 */
	@ExcelAttribute(name = "大病是否收费",readConverterExp = "0=收取,1=不收取")
	@Schema(description = "大病是否收费:  0收取；1不收取")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病是否收费")
	private String isIllness;

	/**
	 * 大病缴纳周期：收取方式  0.按年 1.按月
	 */
	@ExcelAttribute(name = "大病缴纳周期",readConverterExp = "0=按年,1=按月")
	@Schema(description = "大病缴纳周期：收取方式  0.按年 1.按月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病缴纳周期")
	private String collectType;
	/**
	 * 收费模式： 0=立即收费,1=次年起收
	 */
	@ExcelAttribute(name = "收费模式",readConverterExp = "0=立即收费,1=次年起收")
	@Schema(description = "收费模式： 0=立即收费,1=次年起收")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费模式")
	private String isChargePersonal;

	/**
	 * 缴纳月份：周期为年--收取月份  1到12月份
	 */
	@ExcelAttribute(name = "缴纳月份",readConverterExp = "1=一月,2=二月,3=三月,4=四月,5=五月,6=六月,7=七月,8=八月,9=九月,10=十月,11=十一月,12=十二月")
	@Schema(description = "缴纳月份：周期为年--收取月份  1到12月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳月份")
	private String collectMoth;

	/**
	 * 缴纳方式：周期为月--取值方式 0.按定值1按比例
	 */
	@ExcelAttribute(name = "缴纳方式",readConverterExp = "0=按定值,1=按比例")
	@Schema(description = "缴纳方式")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳方式")
	private String valueType;

	/**
	 * 单位大病金额（元/人）--按定值
	 */
	@ExcelAttribute(name = "单位大病金额")
	@Schema(description = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额")
	private BigDecimal chargeCompany;

	/**
	 * 个人大病金额（元/人）--按定值
	 */
	@ExcelAttribute(name = "个人大病金额")
	@Schema(description = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal chargePersonal;


	/**
	 * 单位医疗缴纳比例
	 */
	@ExcelAttribute(name = "单位医疗比例")
	@Schema(description = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPro;

	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@Schema(description = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPro;

	/**
	 * 单位生育缴纳比例
	 */
	@ExcelAttribute(name = "单位生育比例")
	@Schema(description = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPro;

	/**
	 * 单位养老缴纳比例
	 */
	@ExcelAttribute(name = "单位养老比例")
	@Schema(description = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPersionPro;

	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@Schema(description = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPersionPro;

	/**
	 * 单位工伤缴纳比例
	 */
	@ExcelAttribute(name = "单位工伤比例")
	@Schema(description = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitInjuryPro;

	/**
	 * 单位失业缴纳比例
	 */
	@ExcelAttribute(name = "单位失业比例")
	@Schema(description = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPro;

	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@Schema(description = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPro;

	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@Schema(description = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal payCompanyPro;

	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@Schema(description = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal payPersonalPro;

	/**
	 * 是否可以补缴： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否可以补缴",readConverterExp = "0=是,1=否")
	@Schema(description = "是否可以补缴： 0：是，1：否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否可以补缴")
	private String canOverpay;


	/**
	 * 单位比例合计
	 */
	@ExcelAttribute(name = "单位比例合计")
	@Schema(description = "单位比例合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位比例合计")
	private BigDecimal unitProSum;

	/**
	 * 个人比例合计
	 */
	@ExcelAttribute(name = "个人比例合计")
	@Schema(description = "个人比例合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人比例合计")
	private BigDecimal personalProSum;

	/**
	 * 补缴险种-整合字段
	 */
	@ExcelAttribute(name = "补缴险种")
	@Schema(description = "补缴险种")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴险种")
	private String insurancePension;

	/**
	 * 最大补缴期限
	 */
	@ExcelAttribute(name = "最大补缴期限", readConverterExp = "1=一个月,2=二个月,3=三个月,4=四个月,5=五个月,6=六个月,7=七个月,8=八个月,9=九个月,10=十个月,11=十一个月,12=十二个月")
	@Schema(description = "最大补缴期限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最大补缴期限")
	private String overpayNumber;

	/**
	 * 是否含起缴当月： 0：是，1：否
	 */
	@ExcelAttribute(name = "是否含起缴当月",readConverterExp = "0=是,1=否")
	@Schema(description = "是否含起缴当月： 0：是，1：否")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否含起缴当月")
	private String haveThisMonth;

	/**
	 * 补缴险种-补缴是否采用最新基数0是1否
	 */
	@ExcelAttribute(name = "补缴基数", readConverterExp = "0=最新基数,1=当期基数")
	@Schema(description = "补缴基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴基数")
	private String insuranceIsLatestCardinality;

	/**
	 * 补缴政策（社保或公积金）
	 */
	@ExcelAttribute(name = "补缴政策")
	@Schema(description = "补缴政策")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("补缴政策")
	private String payPolicy;

}
