/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 证明开具记录表
 *
 * @author fxj
 * @date 2022-06-25 11:05:11
 */
@Data
@TableName("t_cert_record")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "证明开具记录表")
public class TCertRecord extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "主键" )
    @Schema(description ="主键")
    private String id;

    /**
     * 员工ID
     */
    @ExcelAttribute(name = "员工ID" )
    @Schema(description ="员工ID")
    private String empId;

    /**
     * 员工姓名
     */
    @ExcelAttribute(name = "员工姓名" )
    @Schema(description ="员工姓名")
    private String empName;

    /**
     * 员工身份证
     */
    @ExcelAttribute(name = "员工身份证" )
    @Schema(description ="员工身份证")
    private String empIdcard;

    /**
     * 项目id
     */
    @ExcelAttribute(name = "项目id" )
    @Schema(description ="项目id")
    private String deptId;
	/**
     * 项目名称
     */
    @ExcelAttribute(name = "项目名称" )
    @Schema(description ="项目名称")
    private String projectName;

    /**
     * 项目编码
     */
    @ExcelAttribute(name = "项目编码" )
    @Schema(description ="项目编码")
    private String projectCode;

    /**
     * 岗位
     */
    @ExcelAttribute(name = "岗位" )
    @Schema(description ="岗位")
    private String post;

    /**
     * 合同开始时间
     */
    @ExcelAttribute(name = "合同开始时间" )
    @Schema(description ="合同开始时间")
    private Date contractStart;

    /**
     * 合同截止时间
     */
    @ExcelAttribute(name = "合同截止时间" )
    @Schema(description ="合同截止时间")
    private Date contractEnd;

    /**
     * 开具当天时间
     */
    @ExcelAttribute(name = "开具当天时间" )
    @Schema(description ="开具当天时间")
    private LocalDateTime openCurTime;

    /**
     * 印章名称
     */
    @ExcelAttribute(name = "印章名称" )
    @Schema(description ="印章名称")
    private String seal;

    /**
     * 证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明
     */
    @ExcelAttribute(name = "证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明" )
    @Schema(description ="证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明")
    private String type;

    /**
     * 离职时间
     */
    @ExcelAttribute(name = "离职时间" )
    @Schema(description ="离职时间")
    private Date leaveTime;

    /**
     * 派减原因
     */
    @ExcelAttribute(name = "派减原因" )
    @Schema(description ="派减原因")
    private String leaveReason;

    /**
     * 性别：1男 2女
     */
    @ExcelAttribute(name = "性别" )
    @Schema(description ="性别：1男 2女,和档案一致")
    private String sex;

    /**
     * 入职时间（来我单位时间）
     */
    @ExcelAttribute(name = "入职时间（来我单位时间）" )
    @Schema(description ="入职时间（来我单位时间）")
    private Date entryTime;

    /**
     * 签订合同时间-第一次
     */
    @ExcelAttribute(name = "签订合同时间-第一次" )
    @Schema(description ="签订合同时间-第一次")
    private Date firstContractTime;

    /**
     * 开具人
     */
    @ExcelAttribute(name = "开具人" )
    @Schema(description ="开具人")
    private String opener;

    /**
     * 开具时间
     */
    @ExcelAttribute(name = "开具时间" )
    @Schema(description ="开具时间")
    private Date openTime;

    /**
     * 介绍单位
     */
    @ExcelAttribute(name = "介绍单位" )
    @Schema(description ="介绍单位")
    private String introductionUnit;

    /**
     * 参保时间
     */
    @ExcelAttribute(name = "参保时间" )
    @Schema(description ="参保时间")
    private Date socialTime;


}
