package com.yifu.cloud.plus.v1.business.entity.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端结算表
 *
 * @author hgw
 * @date 2021-08-16 15:58:09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_settle")
@Schema(description = "B端结算表")
public class TBusSettle extends Model<TBusSettle> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "")
     private String id;
     /**
      * 报账部门
      */
     @Length(max = 100, message = "报账部门不能超过100个字符")
     @ExcelAttribute(name = "报账部门", maxLength = 100)
     @Schema(description = "报账部门")
     private String accountDeptName;
     /**
      * 结算月
      */
     @Length(max = 6, message = "结算月不能超过6个字符")
     @ExcelAttribute(name = "结算月", maxLength = 6)
     @Schema(description = "结算月")
     private String settleMonth;
     /**
      * 创建人id
      */
     @NotBlank(message = "创建人id不能为空")
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id不能为空", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 删除标志，0未删除
      */
     @ExcelAttribute(name = "删除标志，0未删除")
     @Schema(description = "删除标志，0未删除")
     private Integer deleteFlag;
}
