/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 导出-法大大专业版模版映射表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
@ColumnWidth(10)
public class TFascTemplateDetailExportVo {

	@ExcelAttribute(name = "法大大模版名称")
	@ExcelProperty("法大大模版名称")
	private String signTemplateName;

	@ExcelAttribute(name = "模版ID", isNotEmpty = true, errorInfo = "模版ID不能为空", maxLength = 100)
	@ExcelProperty("模版ID")
	private String signTemplateId;

	@ExcelAttribute(name = "模版状态")
	@ExcelProperty("模版状态")
	private String signTemplateStatus;
	/**
	 * 法大大字段
	 */
	@ExcelAttribute(name = "法大大字段", maxLength = 100)
	@Length(max = 100, message = "法大大字段不能超过100个字符")
	@ExcelProperty("法大大字段")
	@Schema(description = "法大大字段")
	private String fascField;
	/**
	 * 法大大字段ID
	 */
	@ExcelAttribute(name = "法大大字段ID", maxLength = 100)
	@Length(max = 100, message = "法大大字段ID不能超过100个字符")
	@ExcelProperty("法大大字段ID")
	@Schema(description = "法大大字段ID")
	private String fascFieldId;
	/**
	 * 是否必填0否1是
	 */
	@ExcelAttribute(name = "是否必填", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@ExcelProperty("是否必填")
	private String isMust;
	/**
	 * 是否删除0否1是
	 */
	@ExcelAttribute(name = "是否删除", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@ExcelProperty("是否删除")
	private String deleteFlag;

	@ExcelAttribute(name = "对应皖信合同类型")
	@ExcelProperty("对应皖信合同类型")
	private String contractType;
	/**
	 * 皖信字段
	 */
	@ExcelAttribute(name = "皖信字段", maxLength = 100)
	@ExcelProperty("皖信字段")
	private String hrField;
	/**
	 * 皖信字段ID
	 */
	@ExcelAttribute(name = "皖信字段ID", maxLength = 100)
	@ExcelProperty("皖信字段ID")
	private String hrFieldId;
	/**
	 * 是否已配置0未配置1已配置
	 */
	@ExcelAttribute(name = "是否已配置", maxLength = 3, isDataId = true, readConverterExp = "0=未配置,1=已配置")
	@ExcelProperty("是否已配置")
	private String isEdit;

}
