package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSet;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSetDetail;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryStandardSetMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetDetailService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 薪资工资条配置主表
 *
 * @author hgw
 * @date 2021-10-08 14:36:57
 */
@AllArgsConstructor
@Slf4j
@Service("tSalaryStandardSetService")
public class TSalaryStandardSetServiceImpl extends ServiceImpl<TSalaryStandardSetMapper, TSalaryStandardSet> implements TSalaryStandardSetService {

     private final TSalaryStandardSetDetailService tSalaryStandardSetDetailService;

     private final TSalaryStandardService tSalaryStandardService;

     /**
      * 薪资工资条配置主表简单分页查询
      *
      * @param tSalaryStandardSet 薪资工资条配置主表
      * @return
      */
     @Override
     public IPage<TSalaryStandardSet> getTSalaryStandardSetPage(Page<TSalaryStandardSet> page
             , TSalaryStandardSet tSalaryStandardSet) {
          return baseMapper.getTSalaryStandardSetPage(page, tSalaryStandardSet);
     }

     /**
      * @param salaryId 工资主表id
      * @param deptId   结算主体id
      * @Description: 复制工资条配置，根据结算主体id
      * @Author: hgw
      * @Date: 2021/10/8 15:53
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     @Override
     public void copyLastSetByDeptId(String salaryId, String deptId, String userId) {
          if (Common.isNotNull(salaryId) && Common.isNotNull(deptId)) {
               TSalaryStandardSet ss = this.lambdaQuery().eq(TSalaryStandardSet::getDeptId, deptId).last("order by CREATE_TIME desc limit 1").one();
               if (ss != null && Common.isNotNull(ss.getId())) {
                    List<TSalaryStandardSetDetail> detailList = tSalaryStandardSetDetailService.list(
                            Wrappers.<TSalaryStandardSetDetail>query().lambda().eq(TSalaryStandardSetDetail::getSetId, ss.getId()));
                    TSalaryStandardSet newSet = new TSalaryStandardSet();
                    newSet.setCreateTime(LocalDateTime.now());
                    newSet.setCreateBy(userId);
                    newSet.setIsZero(ss.getIsZero());
                    newSet.setSalaryId(salaryId);
                    newSet.setDeptId(deptId);
                    // 保存主表
                    this.save(newSet);
                    // 保存明细表
                    this.saveDetail(detailList, newSet);
               }
          }
     }

     /**
      * @param detailList
      * @param newSet
      * @Description: 保存明细表
      * @Author: hgw
      * @Date: 2021/10/8 15:52
      * @return: void
      **/
     private void saveDetail(List<TSalaryStandardSetDetail> detailList, TSalaryStandardSet newSet) {
          if (detailList != null && !detailList.isEmpty()) {
               TSalaryStandardSetDetail newDetail;
               for (TSalaryStandardSetDetail detail : detailList) {
                    newDetail = new TSalaryStandardSetDetail();
                    newDetail.setSetId(newSet.getId());
                    newDetail.setCnName(detail.getCnName());
                    newDetail.setOrderLine(detail.getOrderLine());
                    tSalaryStandardSetDetailService.save(newDetail);
               }
          }
     }

     @Override
     public R<TSalaryStandardSet> saveOrUpdateSet(TSalaryStandardSet tSalaryStandardSet) {
          YifuUser user = SecurityUtils.getUser();
          if (user == null || user.getId() == null) {
               return R.failed("未获取到登录人信息！");
          }
          if (Common.isEmpty(tSalaryStandardSet.getSalaryId())) {
               TSalaryStandard ss = tSalaryStandardService.getById(tSalaryStandardSet.getSalaryId());
               if (!ss.getCreateBy().equals(String.valueOf(user.getId()))) {
                    return R.failed("非创建人，不可编辑！");
               }
          }
          if (Common.isEmpty(tSalaryStandardSet.getId())) {
               tSalaryStandardSet.setCreateTime(LocalDateTime.now());
               tSalaryStandardSet.setCreateBy(String.valueOf(user.getId()));
               this.save(tSalaryStandardSet);
          } else {
               this.updateById(tSalaryStandardSet);
               tSalaryStandardSetDetailService.remove(Wrappers.<TSalaryStandardSetDetail>query().lambda().eq(TSalaryStandardSetDetail::getSetId, tSalaryStandardSet.getId()));
          }
          if (tSalaryStandardSet.getDetailList() != null && !tSalaryStandardSet.getDetailList().isEmpty()) {
               for (TSalaryStandardSetDetail detail : tSalaryStandardSet.getDetailList()) {
                    detail.setId(null);
                    detail.setSetId(tSalaryStandardSet.getId());
                    tSalaryStandardSetDetailService.save(detail);
               }
          }
          return new R<>(tSalaryStandardSet);
     }

}
