/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 档案批量更新导入的表格内容
 *
 * @author hgw
 * @date 2024-10-17 15:30:41
 */
@Data
public class PreUploadEmpImportTwoVo implements Serializable {

	// （字典值，0外包1派遣2代理）
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE, maxLength = 4)
	private String empNatrue;
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	private String empName;
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20)
	private String empIdcard;
	@ExcelAttribute(name = "身份证开始日期", isDate = true)
	private String validityStart;
	@ExcelAttribute(name = "身份证截止日期", isDate = true, pattern = "validityStart")
	private String validityEnd;
	@ExcelAttribute(name = "婚姻状况", isDataId = true, dataType = ExcelAttributeConstants.EMP_MARRIED, maxLength = 32)
	private String empMarriStatus;
	@ExcelAttribute(name = "民族", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATIONAL, maxLength = 32)
	private String empNational;
	@ExcelAttribute(name = "政治面貌", isDataId = true, dataType = ExcelAttributeConstants.EMP_POLITICAL, maxLength = 32)
	private String politicalStatus;
	@ExcelAttribute(name = "手机号码", isPhone = true, maxLength = 32)
	private String empPhone;
	@ExcelAttribute(name = "邮箱", maxLength = 50)
	private String empEmail;
	// 区域ID
	@ExcelAttribute(name = "户籍所在地-省", isArea = true)
	private String idProvince;
	@ExcelAttribute(name = "户籍所在地-市", isArea = true, parentField = "idProvince")
	private String idCity;
	@ExcelAttribute(name = "户籍所在地-区/县", isArea = true, parentField = "idCity")
	private String idTown;
	@ExcelAttribute(name = "户口性质", isDataId = true, dataType = ExcelAttributeConstants.EMP_REGISTYPE, maxLength = 32)
	private String empRegisType;
	@ExcelAttribute(name = "档案所在地-省", isArea = true)
	private String fileProvince;
	@ExcelAttribute(name = "档案所在地-市", isArea = true, parentField = "fileProvince")
	private String fileCity;
	@ExcelAttribute(name = "档案所在地-区/县", isArea = true, parentField = "fileCity")
	private String fileTown;
	@ExcelAttribute(name = "通信地址-省", isArea = true)
	private String contactProvince;
	@ExcelAttribute(name = "通信地址-市", isArea = true, parentField = "contactProvince")
	private String contactCity;
	@ExcelAttribute(name = "通信地址-区/县", isArea = true, parentField = "contactCity")
	private String contactTown;
	@ExcelAttribute(name = "通信地址-详细地址", maxLength = 200)
	private String contactAddress;
	@ExcelAttribute(name = "备注", maxLength = 200)
	private String remark;

	// 预入职-员工学历信息表
	// private TPreEmpEducation tpreEmpEducation
	// 学历	学校	专业	教育开始时间	教育结束时间	是否大专及以上	最高学历
	@ExcelAttribute(name = "是否大专及以上", isDataId = true, readConverterExp = "0=否,1=是")
	private String isCollege;
	@ExcelAttribute(name = "最高学历", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION, maxLength = 32)
	private String educationName;
	@ExcelAttribute(name = "学校", maxLength = 50)
	private String school;
	@ExcelAttribute(name = "专业", maxLength = 50)
	private String major;
	@ExcelAttribute(name = "入学时间", isDate = true)
	private String entryDate;
	@ExcelAttribute(name = "毕业时间", isDate = true, pattern = "entryDate")
	private String gradutionDate;

	// 1.9.7：主要工作经历（t_emp_work_recording）
	@ExcelAttribute(name = "是否为首份工作", isDataId = true, readConverterExp = "0=否,1=是")
	private String isFirstWork;
	@ExcelAttribute(name = "工作单位", maxLength = 100)
	private String workUnit;
	@ExcelAttribute(name = "工作岗位", maxLength = 100)
	private String workJob;
	@ExcelAttribute(name = "开始工作日期", isDate = true, dateFormat = LocalDateTimeUtils.DATE_TIME_PATTERN_DEFAULT)
	private String startDate;
	@ExcelAttribute(name = "结束工作日期", isDate = true, pattern = "startDate", dateFormat = LocalDateTimeUtils.DATE_TIME_PATTERN_DEFAULT)
	private String endDate;

	// 1.9.7：主要家庭成员信息（t_emp_family）
	@ExcelAttribute(name = "家庭成员姓名", maxLength = 20)
	private String familyName;
	@ExcelAttribute(name = "家庭成员与本人关系", isDataId = true,dataType = ExcelAttributeConstants.FAMILY_RELATION, maxLength = 32)
	private String relationshipSelf;
	@ExcelAttribute(name = "手机号码（家庭成员）", isPhone = true, maxLength = 32)
	private String contractTel;


	// 紧急联系人
	// private TPreEmpContactInfo tpreEmpContactInfo
	// 紧急联系人姓名	与本人关系	联系地址-省	联系地址-市	联系地址-区/县	联系地址-详细地址	手机号码（紧急联系人）
	@ExcelAttribute(name = "紧急联系人姓名", errorInfo = "紧急联系人姓名不能为空", maxLength = 20)
	private String contactEmpName;
	@ExcelAttribute(name = "紧急联系人与本人关系", errorInfo = "与本人关系不能为空", maxLength = 50)
	private String relationType;
	@ExcelAttribute(name = "联系地址-省", isArea = true)
	private String relationProvince;
	@ExcelAttribute(name = "联系地址-市", isArea = true, parentField = "relationProvince")
	private String relationCity;
	@ExcelAttribute(name = "联系地址-区/县", isArea = true, parentField = "relationCity")
	private String relationTown;
	@ExcelAttribute(name = "联系地址-详细地址", errorInfo = "联系地址-街道、详情不能为空", maxLength = 200)
	private String address;
	@ExcelAttribute(name = "手机号码（紧急联系人）", isPhone = true, errorInfo = "手机号码（紧急联系人）不能为空", maxLength = 20)
	private String tel;

	// 银行卡号	开户总行	开户省	开户市	开户支行	计税月份
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	private String bankNo;
	@ExcelAttribute(name = "开户总行", maxLength = 50)
	private String bankName;
	@ExcelAttribute(name = "开户省", isArea = true)
	private String bankProvince;
	@ExcelAttribute(name = "开户市", isArea = true, parentField = "bankProvince")
	private String bankCity;
	@ExcelAttribute(name = "开户支行", maxLength = 50)
	private String bankSubName;
	@ExcelAttribute(name = "计税月份", isDate = true, dateFormat = "yyyyMM", maxLength = 6)
	private String taxMonth;

	@ExcelAttribute(name = "是否有不良记录", isDataId = true, readConverterExp = "0=是,1=否")
	private String badRecordFlag;

	@ExcelAttribute(name = "是否有职业资格证书", isDataId = true, readConverterExp = "0=是,1=否")
	private String haveQualification;
	// 1.9.7： 职业资格信息
	@ExcelAttribute(name = "申报年度", isDate = true, dateFormat = "yyyy", maxLength = 6)
	private String declareYear;
	@ExcelAttribute(name = "职业资格名称", isDataId = true, dataType = ExcelAttributeConstants.QUALIFICATION_TYPE, maxLength = 32)
	private String qualificationType;

	// 1.9.7： 伤残信息(t_emp_disability_info)
	@ExcelAttribute(name = "是否曾被认定为工伤", isDataId = true, readConverterExp = "0=是,1=否", maxLength = 1)
	private String injuryIdentification;
	@ExcelAttribute(name = "是否有职业病", isDataId = true, readConverterExp = "0=是,1=否", maxLength = 1)
	private String occupationalDiseaseFlag;
	@ExcelAttribute(name = "职业病名称", maxLength = 50)
	private String occupationalDisease;
	@ExcelAttribute(name = "是否有传染性疾病", isDataId = true, readConverterExp = "0=是,1=否", maxLength = 1)
	private String infectiousDiseaseFlag;
	@ExcelAttribute(name = "传染病名称", maxLength = 50)
	private String infectiousName;
	@ExcelAttribute(name = "是否被劳动能力鉴定委员会鉴定为具有伤残等级", isDataId = true, readConverterExp = "0=是,1=否", maxLength = 1)
	private String disabilityFlag;
	@ExcelAttribute(name = "伤残病名称", maxLength = 50)
	private String disabilityName;
	@ExcelAttribute(name = "伤残等级",isDataId = true, dataType = ExcelAttributeConstants.DISABILITY_GRADE, maxLength = 32)
	private String disabilityLevel;
	@ExcelAttribute(name = "是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种", isDataId = true, readConverterExp = "0=是,1=否", maxLength = 1)
	private String otherFlag;

	// 字典值起始
	@ExcelAttribute(name = "员工类型-值")
	private String empNatrueValue;
	@ExcelAttribute(name = "婚姻状况-值")
	private String empMarriStatusValue;
	@ExcelAttribute(name = "民族-值")
	private String empNationalValue;
	@ExcelAttribute(name = "政治面貌-值")
	private String politicalStatusValue;
	@ExcelAttribute(name = "户籍所在地-省-值")
	private String idProvinceValue;
	@ExcelAttribute(name = "户籍所在地-市-值")
	private String idCityValue;
	@ExcelAttribute(name = "户籍所在地-县-值")
	private String idTownValue;
	@ExcelAttribute(name = "户口性质-值")
	private String empRegisTypeValue;
	@ExcelAttribute(name = "档案所在地-省-值")
	private String fileProvinceValue;
	@ExcelAttribute(name = "档案所在地-市-值")
	private String fileCityValue;
	@ExcelAttribute(name = "档案所在地-县-值")
	private String fileTownValue;
	@ExcelAttribute(name = "通信地址-省-值")
	private String contactProvinceValue;
	@ExcelAttribute(name = "通信地址-市-值")
	private String contactCityValue;
	@ExcelAttribute(name = "通信地址-县-值")
	private String contactTownValue;
	// 紧急联系人
	@ExcelAttribute(name = "联系地址-省-值")
	private String relationProvinceValue;
	@ExcelAttribute(name = "联系地址-市-值")
	private String relationCityValue;
	@ExcelAttribute(name = "联系地址-县-值")
	private String relationTownValue;
	@ExcelAttribute(name = "入学时间-值")
	private Date entryDateValue;
	@ExcelAttribute(name = "毕业时间-值")
	private Date gradutionDateValue;
	// 预入职-员工学历信息表
	@ExcelAttribute(name = "是否大专及以上-值")
	private String isCollegeValue;
	@ExcelAttribute(name = "学历-值")
	private String educationNameValue;
	// 银行卡号	开户总行	开户省	开户市	开户支行	计税月份
	@ExcelAttribute(name = "开户省-值")
	private String bankProvinceValue;
	@ExcelAttribute(name = "开户市-值")
	private String bankCityValue;
	@ExcelAttribute(name = "计税月份-值")
	private String taxMonthValue;

	@ExcelAttribute(name = "身份证开始日期-值")
	private Date validityStartValue;
	@ExcelAttribute(name = "身份证截止日期-值")
	private Date validityEndValue;

	@ExcelAttribute(name = "开始工作日期-值")
	private LocalDateTime startDateValue;
	@ExcelAttribute(name = "结束工作日期-值")
	private LocalDateTime endDateValue;

	@ExcelAttribute(name = "与本人关系-值")
	private String relationshipSelfValue;

	@ExcelAttribute(name = "职业资格名称-值")
	private String qualificationTypeValue;

	@ExcelAttribute(name = "是否曾被认定为工伤-值")
	private String injuryIdentificationValue;
	@ExcelAttribute(name = "是否有职业病-值")
	private String occupationalDiseaseFlagValue;
	@ExcelAttribute(name = "是否有传染性疾病-值")
	private String infectiousDiseaseFlagValue;
	@ExcelAttribute(name = "是否被劳动能力鉴定委员会鉴定为具有伤残等级-值")
	private String disabilityFlagValue;
	@ExcelAttribute(name = "伤残等级-值")
	private String disabilityLevelValue;
	@ExcelAttribute(name = "是否从事过井下、高空、高温、特别繁重体力劳动以及有毒有害工种-值")
	private String otherFlagValue;

	// 字典值结束

	@TableField(exist = false)
	private int lineNum;

	@TableField(exist = false)
	private String errorInfo;

}
