package com.yifu.cloud.plus.v1.business.service.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.system.TBusDept;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;
import java.util.Map;

/**
 * B端部门表
 *
 * @author hgw
 * @date 2021-08-10 10:38:44
 */
public interface TBusDeptService extends IService<TBusDept> {

     /**
      * B端部门表简单分页查询
      *
      * @param tBusDept B端部门表
      * @return
      */
     IPage<TBusDept> getTBusDeptPage(Page<TBusDept> page, TBusDept tBusDept);

     /**
      * @param tBusDept
      * @Description: B端部门表 全部list
      * @Author: hgw
      * @Date: 2021/8/10 16:49
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusDept>
      **/
     List<TBusDept> getTBusDeptList(TBusDept tBusDept);

     List<TBusDept> getTBusDeptListAsso(TBusDept tBusDept);

     /**
      * @param tBusDept
      * @Description: 获取部门名称Map
      * @Author: hgw
      * @Date: 2021/8/18 11:52
      * @return: java.util.Map<java.lang.String, java.lang.Integer>
      **/
     Map<String, Integer> getTBusDeptMap(TBusDept tBusDept);

     /**
      * @param id
      * @param treeLogo
      * @Description: B端部门表 子集list，不含自己
      * @Author: hgw
      * @Date: 2021/8/10 16:49
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusDept>
      **/
     List<TBusDept> getTBusDeptSubList(int id, String treeLogo);

     /**
      * @param id
      * @param name
      * @Description: 获取部门list，判重
      * @Author: hgw
      * @Date: 2021/8/11 16:06
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusDept>
      **/
     List<TBusDept> getDeptByName(Integer id, String name);

     /**
      * @param oldLogo
      * @param newLogo
      * @Description: 批量更新子集的treeLogo
      * @Author: hgw
      * @Date: 2021/8/13 17:27
      * @return: int
      **/
     int updateAllTreeLogo(String oldLogo, String newLogo);

     /**
      * 根据部门父id或等级查询部门列表
      * @param pid 部门pid
      * @param level 部门等级
      * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusDept>>
      * @author: wangweiguo
      * @date: 2021/9/7
      * @since hrob2.1
      */
    R<List<TBusDept>> getBusDepartByLevelOrPid(Integer pid, Integer level);
     /**
      * @Description: 获取部门名称Map
      * @Author: hgw
      * @Date: 2021/8/18 11:52
      * @return: java.util.Map<java.lang.String, java.lang.Integer>
      **/
     Map<String, TBusDept> getAllDeptMap();

}
