package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;


/**
 * 实名校验限定调用API的条数表
 *
 * @author hgw
 * @date 2022-6-10 11:07:37
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_check_api_num")
@Schema(description = "实名校验限定调用API的条数表")
public class TCheckApiNum extends Model<TCheckApiNum> {
     private static final long serialVersionUID = 1L;
     /**
      * 创建月
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;

     /**
      * 当月已调用API总条数，初始默认0条
      */
     @NotNull(message = "当月已调用API总条数不能为空")
     @Schema(description = "当月已调用API总条数")
     private Integer apiNum;
     /**
      * 当月允许调用API总条数，初始默认每月10000条
      */
     @NotNull(message = "当月允许调用API总条数不能为空")
     @Schema(description = "当月允许调用API总条数")
     private Integer canApiNum;
     /**
      * 备注
      */
     @Schema(description = "备注")
     private String remark;
}
