package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpSalaryInfoService;
import com.yifu.cloud.plus.v1.ekp.service.EkpShenhepeizhiService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpDivisionInfoVo;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * 事业部审批配置
 * @author chenyuxi
 * @date 2025/1/15
 * @since 1.7.5
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpShenhepeizhi" )
@Tag(name = "事业部审批配置")
public class TEkpShenhepeizhiController {

	private final EkpShenhepeizhiService shenhepeizhiService;

	@Inner
	@PostMapping("/inner/getDivisionUsernameList")
	public EkpDivisionInfoVo getDivisionUsernameList(@RequestBody EkpDivisionInfoVo divisionInfoVo) {
		return shenhepeizhiService.getDivisionUsernameList(divisionInfoVo);
	}

}
