package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSalaryInfo;
import com.yifu.cloud.plus.v1.ekp.entity.EkpShenhepeizhi;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpSalaryInfoMapper;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpShenhepeizhiMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpSalaryInfoService;
import com.yifu.cloud.plus.v1.ekp.service.EkpShenhepeizhiService;
import com.yifu.cloud.plus.v1.ekp.vo.ClaimInfotVO;
import com.yifu.cloud.plus.v1.ekp.vo.ClaimRebackInfotVO;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpDivisionInfoVo;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
//工资明细表
 *
//@author huyc
//@date 2024-03-11 11:21:56
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class EkpShenhepeizhiServiceImpl extends ServiceImpl<EkpShenhepeizhiMapper, EkpShenhepeizhi> implements EkpShenhepeizhiService {

	@Override
	public EkpDivisionInfoVo getDivisionUsernameList(EkpDivisionInfoVo divisionInfoVo) {
		EkpDivisionInfoVo divisionInfoVoRes = new EkpDivisionInfoVo();
		List<String> divisionUsernameList = new ArrayList<>();
		// 指定事业部配置表负责人标识：0事业部条线负责人；1事业部负责人；2分管副总
		if(CommonConstants.ZERO_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getLineLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		if(CommonConstants.ONE_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getDivisionLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		if(CommonConstants.TWO_STRING.equals(divisionInfoVo.getDivisionIdentification())){
			divisionUsernameList = baseMapper.getFuLoginNameList(divisionInfoVo.getNewLine(), divisionInfoVo.getDivision());
		}
		divisionInfoVoRes.setDivisionUsernameList(divisionUsernameList);
		return divisionInfoVoRes;
	}


}
