package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TEmployeeInsurancePreService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EmployeePreLogListVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsurancePreSearchVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsurancePreVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TEmployeeInsuranceSelectVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeeinsurancepre" )
@Tag(name = "商险待办任务表管理")
public class TEmployeeInsurancePreController {

    private final TEmployeeInsurancePreService tEmployeeInsurancePreService;

	private final MenuUtil menuUtil;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TEmployeeInsurancePre>> getTEmployeeInsurancePrePage(Page<TEmployeeInsurancePre> page, TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeInsurancePre);
		return new R<>(tEmployeeInsurancePreService.getTEmployeeInsurancePrePage(page,tEmployeeInsurancePre));
    }

	/**
	 * 不分页查询
	 * @param tEmployeeInsurancePre 商险待办任务表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/noPage")
	public R<List<TEmployeeInsurancePre>> getTEmployeeInsurancePrePage(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeInsurancePre);
		return new R<>(tEmployeeInsurancePreService.getTEmployeeInsurancePreNoPage(tEmployeeInsurancePre));
	}

    /**
     * 通过id查询商险待办任务表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TEmployeeInsurancePre> getById(@PathVariable("id" ) String id) {
        return R.ok(tEmployeeInsurancePreService.getById(id));
    }

    /**
     * 新增商险待办任务表
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return R
     */
    @Operation(summary = "新增商险待办任务表", description = "新增商险待办任务表")
    @SysLog("新增商险待办任务表" )
    @PostMapping
    public R<Boolean> save(@RequestBody TEmployeeInsurancePre tEmployeeInsurancePre) {
        return R.ok(tEmployeeInsurancePreService.save(tEmployeeInsurancePre));
    }

    /**
     * 修改商险待办任务表
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return R
     */
    @Operation(summary = "修改商险待办任务表", description = "修改商险待办任务表")
    @SysLog("修改商险待办任务表" )
    @PutMapping
    public R<Boolean> updateById(@RequestBody TEmployeeInsurancePre tEmployeeInsurancePre) {
        return R.ok(tEmployeeInsurancePreService.updateById(tEmployeeInsurancePre));
    }

    /**
     * 通过id删除商险待办任务表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除商险待办任务表", description = "通过id删除商险待办任务表：hasPermission('insurances_temployeeinsurancepre_del')")
    @SysLog("通过id删除商险待办任务表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_temployeeinsurancepre_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tEmployeeInsurancePreService.removeById(id));
    }

    /**
     * 商险待办任务表 批量导出
     * @author huych
     * @date 2025-03-31 12:25:13
     **/
    @Operation(description = "导出商险待办任务表")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody TEmployeeInsurancePreSearchVo searchVo) {
		tEmployeeInsurancePreService.listExport(response,searchVo);
    }

	/**
	 * 商险派单信息单个/批量确认
	 * @author huych
	 * @date 2025-03-31 12:25:13
	 **/
	@Operation(description = "商险派单信息单个/批量确认")
	@PostMapping("/confirm")
	public R confirm(@RequestBody List<String> idList) {
		return tEmployeeInsurancePreService.confirm(idList);
	}


	/**
	 * 商险派单信息批量派单
	 * @author huych
	 * @date 2025-03-31 12:25:13
	 **/
	@Operation(description = "商险派单信息单个/批量派单")
	@PostMapping("/batchDispatcherInsurance")
	public R batchDispatcherInsurance(@RequestBody List<String> idList) {
		return tEmployeeInsurancePreService.batchDispatcherInsurance(idList);
	}

	/**
	 * 商险派单信息查询
	 * @author huych
	 * @date 2025-04-08 14:31:35
	 **/
	@Operation(description = "商险派单入职确认信息查询")
	@Inner
	@PostMapping("/inner/selectInsurancePreInfoList")
	public TEmployeeInsuranceSelectVo selectInsurancePreInfoList(@RequestBody TEmployeeInsurancePreVo preVo) {
		return tEmployeeInsurancePreService.selectInsurancePreInfoList(preVo);
	}

	/**
	 * 新增商险待购买
	 * @author huych
	 * @date 2025-04-09 9:26:35
	 **/
	@Operation(description = "新增商险待购买")
	@Inner
	@PostMapping("/inner/saveInsurancePreInfo")
	public Boolean saveInsurancePreInfo(@RequestBody EmployeeRegistrationPreVo preVo) {
		return tEmployeeInsurancePreService.saveInsurancePreInfo(preVo);
	}

	/**
	 * 更新商险待购买的前端客服姓名
	 * @author huych
	 * @date 2025-04-09 9:26:35
	 **/
	@Operation(description = "更新商险待购买的前端客服姓名")
	@Inner
	@PostMapping("/inner/updateInsurancePreCustomerName")
	public void updateInsurancePreCustomerName(@RequestBody EmployeeRegistrationCustomerUserUpdateVo updateVo) {
		tEmployeeInsurancePreService.updateInsurancePreCustomerName(updateVo);
	}

	/**
	 * 派单当日9点统一推送确认信息
	 * @author huych
	 * @date 2025-04-09 9:33:16
	 * @return void
	 */
	@SysLog("派单当日9点统一推送确认信息")
	@Inner
	@PostMapping("/inner/pushWxConfrimMessage")
	public void pushWxConfrimMessage() {
		tEmployeeInsurancePreService.pushWxConfrimMessage();
	}

	/**
	 * @param empPreId 入职确认信息表ID
	 * @Description: 获取商险信息
	 * @Author: hgw
	 * @Date: 2025/4/8 9:23
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre>>
	 **/
	@Inner
	@PostMapping("/inner/getListByEmpPreId")
	public EmployeePreLogListVo getListByEmpPreId(@RequestBody String empPreId){
		return tEmployeeInsurancePreService.getListByEmpPreId(empPreId);
	}

	@Inner
	@PostMapping("/inner/saveOrUpdateInsuranceList")
	public Boolean saveOrUpdateInsuranceList(@RequestBody List<TEmployeeInsurancePre> preList) {
		return tEmployeeInsurancePreService.saveOrUpdateInsuranceList(preList);
	}

}
