package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceEnclosure;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceEnclosureMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceEnclosureService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceEnclosureParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;

/**
* @author Administrator
* @description 针对表【t_insurance_enclosure】的数据库操作Service实现
* @createDate 2022-08-22 16:00:46
*/
@Service
@Slf4j
public class TInsuranceEnclosureServiceImpl extends ServiceImpl<TInsuranceEnclosureMapper, TInsuranceEnclosure> implements TInsuranceEnclosureService {


	private final OSSUtil ossUtil;

	public TInsuranceEnclosureServiceImpl(OSSUtil ossUtil) {
		this.ossUtil = ossUtil;
	}

	/**
	 * 上传商险附件
	 *
	 * @author zhaji
	 * @param file 文件
	 * @param filePath 文件路径
	 * @param remark 备注
	 * @return {@link R}
	 * @throws IOException
	 */
	@Override
	public R uploadInsuranceEnclosure(MultipartFile file, String filePath, String remark) throws IOException {
		YifuUser user = SecurityUtils.getUser();
		if(Common.isEmpty(file)){
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_IS_EMPTY);
		}
		if(!Common.checkInsuranceFile(file.getOriginalFilename())){
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_TYPE_IS_ERROR);
		}
		if (file.getSize() > (CommonConstants.FIFTY_INT*CommonConstants.BYTE*CommonConstants.BYTE)){
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_SIZE_ERROR);
		}
		String fileName = System.currentTimeMillis() + CommonConstants.DOWN_LINE_STRING + file.getOriginalFilename();
		//filePath不传默认存储空间的根目录
		//支持的附件格式
		String key = "";
		if (!Common.isNotNull(filePath)) {
			key = fileName;
		} else {
			key = filePath + CommonConstants.SLASH_SPLIT_LINE_STRING + fileName;
		}
		boolean flag = ossUtil.uploadFileByStream(file.getInputStream(), key, null);
		if (flag) {
			TInsuranceEnclosure insuranceEnclosure = new TInsuranceEnclosure();
			log.info("文件：" + fileName + "上传至存储空间" + ossUtil.getBucketName() + "成功！");
			insuranceEnclosure.setDeleteFlag(CommonConstants.ZERO_INT);
			if(StringUtils.isNotBlank(remark)){
				if(!ValidityUtil.validate50(remark)){
					return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_REMARK_SIZE_ERROR);
				}else{
					insuranceEnclosure.setRemark(remark);
				}
			}
			insuranceEnclosure.setEnclosureName(file.getOriginalFilename());
			insuranceEnclosure.setEnclosureAddress(key);
			insuranceEnclosure.setCreateName(user.getNickname());
			insuranceEnclosure.setCreateTime(LocalDateTime.now());
			try {
				this.save(insuranceEnclosure);
			} catch (Exception e) {
				log.error(InsurancesConstants.OSS_ERROR + e.getMessage());
				ossUtil.deleteObject(null, key);
				return R.failed("failed:" + e.getMessage());
			}
			return R.ok(InsurancesConstants.INSURANCE_ENCLOSURE_UPLOAD_SUCCESS);
		} else {
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_UPLOAD_FAIL);
		}
	}

	/**
	 * 获取电子保单列表
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param param 查询参数
	 * @return {@link R}
	 */
	@Override
	public R getInsuranceEnclosurePage(Page<InsuranceEnclosureParam> page, InsuranceEnclosureParam param) {
		return R.ok(this.baseMapper.getInsuranceEnclosurePage(page,param));
	}

	/**
	 * 获取电子保单地址
	 *
	 * @author zhaji
	 * @param id 附件id
	 * @return {@link R}
	 */
	@Override
	public R getInsuranceEnclosureUrl(String id) {
		if(Common.isEmpty(id)){
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_ID_IS_EMPTY);
		}
		TInsuranceEnclosure insuranceEnclosure = getById(id);
		if (null == insuranceEnclosure) {
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_IS_NOT_EXIST);
		}
		String enclosureAddress = insuranceEnclosure.getEnclosureAddress();
		log.info("key:"+enclosureAddress);
		URL url = ossUtil.getObjectUrl(null, insuranceEnclosure.getEnclosureAddress());
		return new R<>(url.toString());
	}

	/**
	 * 删除电子保单
	 *
	 * @author zhaji
	 * @param id 附件id
	 * @return {@link R}
	 */
	@Override
	public R deleteInsuranceEnclosure(String id) {
		if(Common.isEmpty(id)){
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_ID_IS_EMPTY);
		}
		TInsuranceEnclosure insuranceEnclosure = getById(id);
		if (null == insuranceEnclosure) {
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_IS_NOT_EXIST);
		}
		try {
			if (removeById(id)) {
				ossUtil.deleteObject(null, insuranceEnclosure.getEnclosureAddress());
				return R.ok(InsurancesConstants.INSURANCE_ENCLOSURE_DELETE_SUCCESS);
			}
		} catch (Exception e) {
			log.error("电子保单删除异常：" + e.getMessage()+"电子保单id为："+id);
			return R.failed(InsurancesConstants.INSURANCE_ENCLOSURE_DELETE_ABNORMAL);
		}
		return R.ok(InsurancesConstants.INSURANCE_ENCLOSURE_DELETE_FAIL);
	}
}
