/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 法大大专业版模版映射表_更新VO
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
public class TFascTemplateDetailUpdateVo extends RowIndex implements Serializable {
	//法大大模版名称、模版ID、法大大字段、法大大字段ID、对应皖信合同类型（同一个模版ID只能对应一种类型）、对应皖信字段、对应皖信字段ID
	//法大大模版名称、模版ID、法大大字段、法大大字段ID、对应皖信字段、对应皖信字段ID
	// 对应皖信合同类型——去掉该字段，影响更新效果（填了不校验，也不更新，会产生误解） 2025-09-30 17:32
	/**
	 * 模版名称
	 */
	@NotBlank(message = "法大大模版名称 不能为空")
	@Length(max = 100, message = "法大大模版名称 不能超过100 个字符")
	@ExcelAttribute(isNotEmpty = true, errorInfo = "法大大模版名称 不能为空", name = "法大大模版名称", maxLength = 100)
	@Schema(description = "法大大模版名称")
	@ExcelProperty("法大大模版名称")
	private String signTemplateName;
	/**
	 * 模版ID
	 */
	@NotBlank(message = "模版ID 不能为空")
	@Length(max = 100, message = "模版ID 不能超过100 个字符")
	@ExcelAttribute(name = "模版ID", isNotEmpty = true, errorInfo = "模版ID 不能为空", maxLength = 100)
	@Schema(description = "模版ID")
	@ExcelProperty("模版ID")
	private String signTemplateId;

	/**
	 * 法大大字段
	 */
	@NotBlank(message = "法大大字段 不能为空")
	@Length(max = 100, message = "法大大字段 不能超过100 个字符")
	@ExcelAttribute(isNotEmpty = true, errorInfo = "法大大字段 不能为空", name = "法大大字段", maxLength = 100)
	@Schema(description = "法大大字段")
	@ExcelProperty("法大大字段")
	private String fascField;
	/**
	 * 法大大字段ID
	 */
	@NotBlank(message = "法大大字段ID 不能为空")
	@Length(max = 100, message = "法大大字段ID 不能超过100 个字符")
	@ExcelAttribute(isNotEmpty = true, errorInfo = "法大大字段ID 不能为空", name = "法大大字段ID", maxLength = 100)
	@Schema(description = "法大大字段ID")
	@ExcelProperty("法大大字段ID")
	private String fascFieldId;
	/**
	 * 对应皖信字段
	 */
	@NotBlank(message = "对应皖信字段 不能为空")
	@Length(max = 100, message = "对应皖信字段 不能超过100 个字符")
	@ExcelAttribute(isNotEmpty = true, errorInfo = "对应皖信字段 不能为空", name = "对应皖信字段", maxLength = 100)
	@Schema(description = "对应皖信字段")
	@ExcelProperty("对应皖信字段")
	private String hrField;
	/**
	 * 对应皖信字段ID
	 */
	@NotBlank(message = "对应皖信字段ID 不能为空")
	@Length(max = 100, message = "对应皖信字段ID 不能超过100 个字符")
	@ExcelAttribute(isNotEmpty = true, errorInfo = "对应皖信字段ID 不能为空", name = "对应皖信字段ID", maxLength = 100)
	@Schema(description = "对应皖信字段ID")
	@ExcelProperty("对应皖信字段ID")
	private String hrFieldId;

}
