/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpOtherFile;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpOtherFileService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 档案-其他附件主表
 *
 * @author hgw
 * @date 2024-07-17 14:56:33
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempotherfile" )
@Tag(name = "档案-其他附件主表管理")
public class TEmpOtherFileController {

    private final  TEmpOtherFileService tEmpOtherFileService;

    /**
     * 获取其他附件list-档案
     * @param empId 获取其他附件list-档案
     * @return
     */
    @Operation(summary = "获取其他附件list-档案", description = "获取其他附件list-档案")
    @GetMapping("/getTEmpOtherFileListAndFile" )
    public R<List<TEmpOtherFile>> getTEmpOtherFileListAndFile(@RequestParam String empId) {
        return R.ok(tEmpOtherFileService.getTEmpOtherFileListAndFile(empId));
    }
}
