package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * @author zhaji
 * @description 订单商险列表查询
 * @date 2022-08-29 14:44:25
 */
@Data
@Tag(name = "订单商险列表查询")
public class InsuredOrderParam extends BaseEntity {
	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;
	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 开始日期
	 */
	@Schema(description = "开始日期")
	private LocalDate startDate;

	/**
	 * 结束日期
	 */
	@Schema(description = "结束日期")
	private LocalDate endDate;

	/**
	 * 项目编码列表
	 */
	@Schema(description = "项目编码列表")
	private List<String> deptNoList;


}
