/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 项目薪资查询权限配置表-薪资配置1
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TDeptSeeVo extends RowIndex implements Serializable {

	/**
	 * 项目id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "项目id 不能为空")
	@Length(max = 32, message = "项目id 不能超过32 个字符")
	@ExcelAttribute(name = "项目id", isNotEmpty = true, errorInfo = "项目id 不能为空", maxLength = 32)
	@Schema(description = "项目id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String id;
	/**
	 * 项目名称
	 */
	@NotBlank(message = "项目名称 不能为空")
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目名称 不能为空", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 是否可查看工资：0否；1是
	 */
	@NotBlank(message = "是否可查看工资：0否；1是 不能为空")
	@ExcelAttribute(name = "是否可查看工资：0否；1是", isNotEmpty = true, errorInfo = "是否可查看工资：0否；1是 不能为空")
	@Schema(description = "是否可查看工资：0否；1是")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否可查看工资：0否；1是")
	private Integer canSee;

}
