package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePerson;
import com.yifu.cloud.plus.v1.yifu.salary.service.TInsuranceUnpurchasePersonService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tinsuranceunpurchaseperson" )
@Tag(name = "含风险项目不购买申请明细表管理")
public class TInsuranceUnpurchasePersonController {

    private final TInsuranceUnpurchasePersonService tInsuranceUnpurchasePersonService;

	private final MenuUtil menuUtil;
    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param searchVo 含风险项目不购买申请明细表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TInsuranceUnpurchasePerson>> getTInsuranceUnpurchasePersonPage(Page<TInsuranceUnpurchasePerson> page, TInsuranceUnpurchasePersonSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		return new R<>(tInsuranceUnpurchasePersonService.getTInsuranceUnpurchasePersonPage(page,searchVo));
    }

    /**
     * 通过id查询含风险项目不购买申请明细表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}")
    public R<TInsuranceUnpurchasePerson> getById(@PathVariable("id" ) String id) {
        return tInsuranceUnpurchasePersonService.getPersonInfo(id);
    }

    /**
     * 含风险项目不购买申请明细表 批量导出
     * @author huych
     * @date 2025-01-10 11:23:21
     **/
    @Operation(description = "导出含风险项目不购买申请明细表")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody TInsuranceUnpurchasePersonSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tInsuranceUnpurchasePersonService.listExport(response,searchVo);
    }

	/**
	 * @param id 明细id
	 * @Description: 刷新社保状态
	 * @Author: hgw
	 * @Date: 2025/1/15 13:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "刷新社保状态")
	@GetMapping("/getSocialWorkInjuryHandleById")
	public R<String> getSocialWorkInjuryHandleById(@RequestParam String id) {
		return tInsuranceUnpurchasePersonService.getSocialWorkInjuryHandleById(id);
	}

	/**
	 * @Description: 定时任务刷新不购买里的社保状态
	 * @Author: hgw
	 * @Date: 2025/1/15 13:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	@Operation(description = "定时任务刷新不购买里的社保状态")
	@PostMapping("/inner/doSocialWorkInjuryHandleAll")
	@Inner
	public void doSocialWorkInjuryHandleAll() {
		tInsuranceUnpurchasePersonService.doSocialWorkInjuryHandleAll();
	}

}
