package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Description 公积金补缴清册
 * @Date 19:04 2022/7/27
 * @Param 
 * @return 
**/
@Data
public class FundSupplementaryExportVo implements Serializable {

    /**
     * 员工姓名
     */
    @ExcelAttribute(name = "员工姓名",  errorInfo = "员工姓名不能为空", maxLength = 50,needExport = true)
    private String empName;
    /**
     * 公积金起缴日期
     */
    @NotBlank(message = "公积金起缴日期不能为空")
    @ExcelAttribute(name = "公积金起缴日期",    errorInfo = "公积金起缴日期不能为空",needExport = true)
    @Schema(description = "公积金起缴日期")
    private LocalDateTime providentStart;
    /**
     * 单位公积金缴纳基数
     */
    @NotBlank(message = "单位公积金缴纳基数不能为空")
    @ExcelAttribute(name = "单位公积金缴纳基数",   errorInfo = "单位公积金缴纳基数不能为空",needExport = true)
    @Schema(description = "单位公积金缴纳基数")
    private BigDecimal unitProvidengCardinal;
    /**
     * 单位公积金缴纳比例
     */
    @NotBlank(message = "单位公积金缴纳比例不能为空")
    @ExcelAttribute(name = "单位公积金缴纳比例",  errorInfo = "单位公积金缴纳比例不能为空",needExport = true)
    @Schema(description = "单位公积金缴纳比例")
    private BigDecimal unitProvidentPer;
    /**
     * 单位公积金缴纳费用
     */
    @NotBlank(message = "单位公积金缴纳费用不能为空")
    @ExcelAttribute(name = "单位公积金缴纳费用", isNotEmpty = true, errorInfo = "单位公积金缴纳费用不能为空",needExport = true)
    @Schema(description = "单位公积金缴纳费用")
    private BigDecimal unitProvidentFee;
    /**
     * 个人公积金缴纳基数
     */
    @NotBlank(message = "个人公积金缴纳基数不能为空")
    @ExcelAttribute(name = "个人公积金缴纳基数",  errorInfo = "个人公积金缴纳基数不能为空",needExport = true)
    @Schema(description = "个人公积金缴纳基数")
    private BigDecimal personalProvidentCardinal;
    /**
     * 个人公积金缴纳比例
     */
    @NotBlank(message = "个人公积金缴纳比例不能为空")
    @ExcelAttribute(name = "个人公积金缴纳比例",  errorInfo = "个人公积金缴纳比例不能为空",needExport = true)
    @Schema(description = "个人公积金缴纳比例")
    private BigDecimal personalProvidentPer;
    /**
     * 个人公积金缴纳费用
     */
    @NotBlank(message = "个人公积金缴纳费用不能为空")
    @ExcelAttribute(name = "个人公积金缴纳费用", isNotEmpty = true, errorInfo = "个人公积金缴纳费用不能为空",needExport = true)
    @Schema(description = "个人公积金缴纳费用")
    private BigDecimal personalProvidentFee;

/*******************************导出字段结束*************************************************/
}
